/*
 * Decompiled with CFR 0.152.
 */
package org.grade.configuration.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import org.grade.common.GradeUtils;
import org.grade.common.annotation.Qualifiers;
import org.grade.configuration.Configuration;
import org.grade.configuration.RepositoryConfiguration;
import org.grade.configuration.impl.ConfigurationContext;
import org.grade.configuration.impl.ConfigurationLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationProducers {
    @Produces
    ObjectMapper mapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        return mapper;
    }

    @Produces
    @ApplicationScoped
    Configuration singletonCfg(@Qualifiers.New Configuration configuration) {
        return configuration;
    }

    @Produces
    @Qualifiers.New
    Configuration cfg(ConfigurationLocator locator, ConfigurationContext ctx) {
        Logger log = LoggerFactory.getLogger(ConfigurationLocator.class);
        File location = locator.locate();
        String path = location.getAbsolutePath();
        InputStream stream = null;
        try {
            if (GradeUtils.isValid((File)location)) {
                log.info("loading configuration @ {}", (Object)path);
                stream = new FileInputStream(location);
            } else {
                log.info("starting with default configuration @ {}", (Object)path);
                stream = this.defaultConfiguration();
            }
            return ctx.bind(stream);
        }
        catch (Exception e) {
            throw new RuntimeException("cannot read the configuration @ " + path, e);
        }
    }

    private InputStream defaultConfiguration() {
        InputStream stream = ConfigurationLocator.class.getResourceAsStream("/grade.json");
        if (stream == null) {
            throw new AssertionError((Object)"no default configuration: invalid distribution?");
        }
        return stream;
    }

    @Produces
    @ApplicationScoped
    @Qualifiers.Production
    RepositoryConfiguration prod_cfg(Configuration configuration) {
        return configuration.production();
    }

    @Produces
    @ApplicationScoped
    @Qualifiers.Staging
    RepositoryConfiguration staging_cfg(Configuration configuration) {
        return configuration.staging();
    }

    @Produces
    @ApplicationScoped
    @Qualifiers.Tasks
    RepositoryConfiguration tasks_cfg(Configuration configuration) {
        return configuration.tasks();
    }
}

