/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.crs;

import java.io.IOException;
import java.util.Iterator;
import org.geotools.data.crs.ForceCoordinateSystemIterator;
import org.geotools.data.crs.ReprojectFeatureResults;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.geotools.feature.collection.AbstractFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForceCoordinateSystemFeatureResults
extends AbstractFeatureCollection {
    FeatureCollection<SimpleFeatureType, SimpleFeature> results;

    public ForceCoordinateSystemFeatureResults(FeatureCollection<SimpleFeatureType, SimpleFeature> results, CoordinateReferenceSystem forcedCS) throws IOException, SchemaException {
        this(results, forcedCS, false);
    }

    public ForceCoordinateSystemFeatureResults(FeatureCollection<SimpleFeatureType, SimpleFeature> results, CoordinateReferenceSystem forcedCS, boolean forceOnlyMissing) throws IOException, SchemaException {
        super(ForceCoordinateSystemFeatureResults.forceType(ForceCoordinateSystemFeatureResults.origionalType(results), forcedCS, forceOnlyMissing));
        this.results = results;
    }

    private static SimpleFeatureType origionalType(FeatureCollection<SimpleFeatureType, SimpleFeature> results) {
        if (results instanceof ReprojectFeatureResults) {
            results = ((ReprojectFeatureResults)results).getOrigin();
        }
        if (results instanceof ForceCoordinateSystemFeatureResults) {
            results = ((ForceCoordinateSystemFeatureResults)results).getOrigin();
        }
        return results.getSchema();
    }

    @Override
    public Iterator<SimpleFeature> openIterator() {
        return new ForceCoordinateSystemIterator(this.results.features(), this.getSchema());
    }

    public void closeIterator(Iterator close) {
        if (close == null) {
            return;
        }
        if (close instanceof ForceCoordinateSystemIterator) {
            ForceCoordinateSystemIterator iterator = (ForceCoordinateSystemIterator)close;
            iterator.close();
        }
    }

    @Override
    public int size() {
        return this.results.size();
    }

    private static SimpleFeatureType forceType(SimpleFeatureType startingType, CoordinateReferenceSystem forcedCS, boolean forceOnlyMissing) throws SchemaException {
        CoordinateReferenceSystem originalCs;
        if (forcedCS == null) {
            throw new NullPointerException("CoordinateSystem required");
        }
        CoordinateReferenceSystem coordinateReferenceSystem = originalCs = startingType.getGeometryDescriptor() != null ? startingType.getGeometryDescriptor().getCoordinateReferenceSystem() : null;
        if (forcedCS.equals(originalCs)) {
            return startingType;
        }
        return FeatureTypes.transform(startingType, forcedCS, forceOnlyMissing);
    }

    @Override
    public ReferencedEnvelope getBounds() {
        ReferencedEnvelope env = this.results.getBounds();
        if (env == null) {
            return null;
        }
        env = new ReferencedEnvelope(env, this.getSchema().getCoordinateReferenceSystem());
        return env;
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> getOrigin() {
        return this.results;
    }
}

