/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.stream.eraf;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UTFDataFormatException;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class EnhancedRandomAccessFile
implements DataInput,
DataOutput {
    public static final int BIG_ENDIAN = 0;
    public static final int LITTLE_ENDIAN = 1;
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    protected File file;
    protected RandomAccessFile eraf;
    protected long filePosition;
    protected byte[] buffer;
    protected long bufferStart;
    protected long dataEnd;
    protected int dataSize;
    protected boolean endOfFile;
    protected boolean readonly;
    protected boolean bigEndian;
    boolean bufferModified = false;
    protected long minLength = 0L;
    boolean extendMode = false;
    protected boolean cached;
    protected String location;

    protected EnhancedRandomAccessFile(int bufferSize) {
        this.eraf = null;
        this.readonly = true;
        this.init(bufferSize);
    }

    public EnhancedRandomAccessFile(File file, String mode) throws IOException {
        this(file, mode, 4096);
    }

    public EnhancedRandomAccessFile(File file, String mode, int bufferSize) throws IOException {
        this.file = file;
        this.eraf = new RandomAccessFile(file, mode);
        this.readonly = mode.equals("r");
        this.init(bufferSize);
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.eraf;
    }

    private void init(int bufferSize) {
        this.bufferStart = 0L;
        this.dataEnd = 0L;
        this.dataSize = 0;
        this.filePosition = 0L;
        this.buffer = new byte[bufferSize];
        this.endOfFile = false;
    }

    public void close() throws IOException {
        if (this.eraf == null) {
            return;
        }
        if (!this.readonly && this.bufferModified) {
            this.eraf.seek(this.bufferStart);
            this.eraf.write(this.buffer, 0, this.dataSize);
        }
        if (!this.readonly && this.minLength != 0L && this.minLength != this.eraf.length()) {
            this.eraf.setLength(this.minLength);
        }
        this.eraf.close();
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isAtEndOfFile() {
        return this.endOfFile;
    }

    public FileChannel getChannel() {
        if (this.eraf == null) {
            return null;
        }
        try {
            this.eraf.seek(0L);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.eraf.getChannel();
    }

    public void seek(long pos) throws IOException {
        if (pos >= this.bufferStart && pos < this.dataEnd) {
            this.filePosition = pos;
            return;
        }
        if (this.bufferModified) {
            this.flush();
        }
        this.bufferStart = pos;
        this.filePosition = pos;
        this.dataSize = this.read_(pos, this.buffer, 0, this.buffer.length);
        if (this.dataSize <= 0) {
            this.dataSize = 0;
            this.endOfFile = true;
        } else {
            this.endOfFile = false;
        }
        this.dataEnd = this.bufferStart + (long)this.dataSize;
    }

    public long getFilePointer() throws IOException {
        return this.filePosition;
    }

    public File getFile() {
        return this.file;
    }

    public long length() throws IOException {
        long fileLength = this.eraf.length();
        if (fileLength < this.dataEnd) {
            return this.dataEnd;
        }
        return fileLength;
    }

    public void setByteOrder(ByteOrder bo) {
        this.bigEndian = bo == ByteOrder.BIG_ENDIAN;
    }

    public ByteOrder getByteOrder() {
        return this.bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    public FileDescriptor getFD() throws IOException {
        return this.eraf == null ? null : this.eraf.getFD();
    }

    public void flush() throws IOException {
        if (this.bufferModified) {
            this.eraf.seek(this.bufferStart);
            this.eraf.write(this.buffer, 0, this.dataSize);
            this.bufferModified = false;
        }
    }

    public void setMinLength(long minLength) {
        this.minLength = minLength;
    }

    public void setExtendMode() {
        this.extendMode = true;
    }

    public int read() throws IOException {
        if (this.filePosition < this.dataEnd) {
            int pos = (int)(this.filePosition - this.bufferStart);
            ++this.filePosition;
            return this.buffer[pos] & 0xFF;
        }
        if (this.endOfFile) {
            return -1;
        }
        this.seek(this.filePosition);
        return this.read();
    }

    protected int readBytes(byte[] b, int off, int len) throws IOException {
        if (this.endOfFile) {
            return -1;
        }
        int bytesAvailable = (int)(this.dataEnd - this.filePosition);
        if (bytesAvailable < 1) {
            this.seek(this.filePosition);
            return this.readBytes(b, off, len);
        }
        int copyLength = bytesAvailable >= len ? len : bytesAvailable;
        System.arraycopy(this.buffer, (int)(this.filePosition - this.bufferStart), b, off, copyLength);
        this.filePosition += (long)copyLength;
        if (copyLength < len) {
            int extraCopy = len - copyLength;
            if (extraCopy > this.buffer.length) {
                extraCopy = this.read_(this.filePosition, b, off + copyLength, len - copyLength);
            } else {
                this.seek(this.filePosition);
                if (!this.endOfFile) {
                    extraCopy = extraCopy > this.dataSize ? this.dataSize : extraCopy;
                    System.arraycopy(this.buffer, 0, b, off + copyLength, extraCopy);
                } else {
                    extraCopy = -1;
                }
            }
            if (extraCopy > 0) {
                this.filePosition += (long)extraCopy;
                return copyLength + extraCopy;
            }
        }
        return copyLength;
    }

    protected int read_(long pos, byte[] b, int offset, int len) throws IOException {
        this.eraf.seek(pos);
        int n = this.eraf.read(b, offset, len);
        if (this.extendMode && n < len) {
            n = len;
        }
        return n;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.readBytes(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this.readBytes(b, 0, b.length);
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        for (int n = 0; n < len; n += count) {
            count = this.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    public int skipBytes(int n) throws IOException {
        this.seek(this.getFilePointer() + (long)n);
        return n;
    }

    public long skipBytes(long n) throws IOException {
        this.seek(this.getFilePointer() + n);
        return n;
    }

    public void unread() {
        --this.filePosition;
    }

    public void write(int b) throws IOException {
        if (this.filePosition < this.dataEnd) {
            this.buffer[(int)(this.filePosition++ - this.bufferStart)] = (byte)b;
            this.bufferModified = true;
        } else if (this.dataSize != this.buffer.length) {
            this.buffer[(int)(this.filePosition++ - this.bufferStart)] = (byte)b;
            this.bufferModified = true;
            ++this.dataSize;
            ++this.dataEnd;
        } else {
            this.seek(this.filePosition);
            this.write(b);
        }
    }

    public void writeBytes(byte[] b, int off, int len) throws IOException {
        if (len < this.buffer.length) {
            long myDataEnd;
            int spaceInBuffer = 0;
            int copyLength = 0;
            if (this.filePosition >= this.bufferStart) {
                spaceInBuffer = (int)(this.bufferStart + (long)this.buffer.length - this.filePosition);
            }
            if (spaceInBuffer > 0) {
                copyLength = spaceInBuffer > len ? len : spaceInBuffer;
                System.arraycopy(b, off, this.buffer, (int)(this.filePosition - this.bufferStart), copyLength);
                this.bufferModified = true;
                myDataEnd = this.filePosition + (long)copyLength;
                this.dataEnd = myDataEnd > this.dataEnd ? myDataEnd : this.dataEnd;
                this.dataSize = (int)(this.dataEnd - this.bufferStart);
                this.filePosition += (long)copyLength;
            }
            if (copyLength < len) {
                this.seek(this.filePosition);
                System.arraycopy(b, off + copyLength, this.buffer, (int)(this.filePosition - this.bufferStart), len - copyLength);
                this.bufferModified = true;
                myDataEnd = this.filePosition + (long)(len - copyLength);
                this.dataEnd = myDataEnd > this.dataEnd ? myDataEnd : this.dataEnd;
                this.dataSize = (int)(this.dataEnd - this.bufferStart);
                this.filePosition += (long)(len - copyLength);
            }
        } else {
            if (this.bufferModified) {
                this.flush();
                this.dataSize = 0;
                this.bufferStart = this.dataEnd = (long)0;
            }
            this.eraf.seek(this.filePosition);
            this.eraf.write(b, off, len);
            this.filePosition += (long)len;
        }
    }

    public void write(byte[] b) throws IOException {
        this.writeBytes(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.writeBytes(b, off, len);
    }

    public boolean readBoolean() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    public byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    public int readUnsignedByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    public short readShort() throws IOException {
        byte[] b = new byte[2];
        if (this.read(b, 0, 2) < 0) {
            throw new EOFException();
        }
        if (this.bigEndian) {
            return (short)(((b[0] & 0xFF) << 8) + (b[1] & 0xFF));
        }
        return (short)(((b[1] & 0xFF) << 8) + (b[0] & 0xFF));
    }

    public void readShort(short[] pa, int start, int n) throws IOException {
        int end = n + start;
        for (int i = start; i < end; ++i) {
            pa[i] = this.readShort();
        }
    }

    public int readUnsignedShort() throws IOException {
        byte[] b = new byte[2];
        if (this.read(b, 0, 2) < 0) {
            throw new EOFException();
        }
        if (this.bigEndian) {
            return ((b[0] & 0xFF) << 8) + (b[1] & 0xFF) & 0xFFFF;
        }
        return ((b[1] & 0xFF) << 8) + (b[0] & 0xFF) & 0xFFFF;
    }

    public char readChar() throws IOException {
        byte[] b = new byte[2];
        if (this.read(b, 0, 2) < 0) {
            throw new EOFException();
        }
        if (this.bigEndian) {
            return (char)(((b[0] & 0xFF) << 8) + (b[1] & 0xFF));
        }
        return (char)(((b[1] & 0xFF) << 8) + (b[0] & 0xFF));
    }

    public int readInt() throws IOException {
        byte[] b = new byte[4];
        if (this.read(b, 0, 4) < 0) {
            throw new EOFException();
        }
        if (this.bigEndian) {
            return ((b[0] & 0xFF) << 24) + ((b[1] & 0xFF) << 16) + ((b[2] & 0xFF) << 8) + (b[3] & 0xFF);
        }
        return ((b[3] & 0xFF) << 24) + ((b[2] & 0xFF) << 16) + ((b[1] & 0xFF) << 8) + (b[0] & 0xFF);
    }

    public long readUnsignedInt() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public int readIntUnbuffered(long pos) throws IOException {
        byte[] bb = new byte[4];
        this.read_(pos, bb, 0, 4);
        int ch1 = bb[0] & 0xFF;
        int ch2 = bb[1] & 0xFF;
        int ch3 = bb[2] & 0xFF;
        int ch4 = bb[3] & 0xFF;
        if ((ch1 | ch2 | ch3 | ch4) < 0) {
            throw new EOFException();
        }
        if (this.bigEndian) {
            return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
        }
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
    }

    public void readInt(int[] pa, int start, int n) throws IOException {
        int end = n + start;
        for (int i = start; i < end; ++i) {
            pa[i] = this.readInt();
        }
    }

    public long readLong() throws IOException {
        byte[] b = new byte[8];
        if (this.read(b, 0, 8) < 0) {
            throw new EOFException();
        }
        if (this.bigEndian) {
            return (((long)b[0] & 0xFFL) << 56) + (((long)b[1] & 0xFFL) << 48) + (((long)b[2] & 0xFFL) << 40) + (((long)b[3] & 0xFFL) << 32) + (((long)b[4] & 0xFFL) << 24) + (((long)b[5] & 0xFFL) << 16) + (((long)b[6] & 0xFFL) << 8) + ((long)b[7] & 0xFFL);
        }
        return (((long)b[7] & 0xFFL) << 56) + (((long)b[6] & 0xFFL) << 48) + (((long)b[5] & 0xFFL) << 40) + (((long)b[4] & 0xFFL) << 32) + (((long)b[3] & 0xFFL) << 24) + (((long)b[2] & 0xFFL) << 16) + (((long)b[1] & 0xFFL) << 8) + ((long)b[0] & 0xFFL);
    }

    public void readLong(long[] pa, int start, int n) throws IOException {
        int end = n + start;
        for (int i = start; i < end; ++i) {
            pa[i] = this.readLong();
        }
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public void readFloat(float[] pa, int start, int n) throws IOException {
        int end = n + start;
        for (int i = start; i < end; ++i) {
            pa[i] = Float.intBitsToFloat(this.readInt());
        }
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public void readDouble(double[] pa, int start, int n) throws IOException {
        int end = n + start;
        for (int i = start; i < end; ++i) {
            pa[i] = Double.longBitsToDouble(this.readLong());
        }
    }

    public String readLine() throws IOException {
        int c;
        StringBuffer input = new StringBuffer();
        while ((c = this.read()) != -1 && c != 10) {
            input.append((char)c);
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public String readString(int nbytes) throws IOException {
        byte[] data = new byte[nbytes];
        this.readFully(data);
        return new String(data);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    public void writeBoolean(boolean[] pa, int start, int n) throws IOException {
        int end = start + n;
        for (int i = start; i < end; ++i) {
            this.writeBoolean(pa[i]);
        }
    }

    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    public void writeShort(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public void writeShort(short[] pa, int start, int n) throws IOException {
        int end = start + n;
        for (int i = start; i < end; ++i) {
            this.writeShort(pa[i]);
        }
    }

    public void writeChar(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public void writeChar(char[] pa, int start, int n) throws IOException {
        int end = start + n;
        for (int i = start; i < end; ++i) {
            this.writeChar(pa[i]);
        }
    }

    public void writeInt(int v) throws IOException {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public void writeInt(int[] pa, int start, int n) throws IOException {
        int end = start + n;
        for (int i = start; i < end; ++i) {
            this.writeInt(pa[i]);
        }
    }

    public void writeLong(long v) throws IOException {
        if (this.bigEndian) {
            this.write((int)(v >>> 56) & 0xFF);
            this.write((int)(v >>> 48) & 0xFF);
            this.write((int)(v >>> 40) & 0xFF);
            this.write((int)(v >>> 32) & 0xFF);
            this.write((int)(v >>> 24) & 0xFF);
            this.write((int)(v >>> 16) & 0xFF);
            this.write((int)(v >>> 8) & 0xFF);
            this.write((int)(v >>> 0) & 0xFF);
        } else {
            this.write((int)(v >>> 0) & 0xFF);
            this.write((int)(v >>> 8) & 0xFF);
            this.write((int)(v >>> 16) & 0xFF);
            this.write((int)(v >>> 24) & 0xFF);
            this.write((int)(v >>> 32) & 0xFF);
            this.write((int)(v >>> 40) & 0xFF);
            this.write((int)(v >>> 48) & 0xFF);
            this.write((int)(v >>> 56) & 0xFF);
        }
    }

    public void writeLong(long[] pa, int start, int n) throws IOException {
        int end = start + n;
        for (int i = start; i < end; ++i) {
            this.writeLong(pa[i]);
        }
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeFloat(float[] pa, int start, int n) throws IOException {
        int end = start + n;
        for (int i = start; i < end; ++i) {
            this.writeFloat(pa[i]);
        }
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeDouble(double[] pa, int start, int n) throws IOException {
        int end = start + n;
        for (int i = start; i < end; ++i) {
            this.writeDouble(pa[i]);
        }
    }

    public void writeBytes(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.write((byte)s.charAt(i));
        }
    }

    public void writeBytes(char[] b, int off, int len) throws IOException {
        for (int i = off; i < len; ++i) {
            this.write((byte)b[i]);
        }
    }

    public void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 0 & 0xFF);
        }
    }

    public void writeUTF(String str) throws IOException {
        char c;
        int i;
        int strlen = str.length();
        int utflen = 0;
        for (i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        this.write(utflen >>> 8 & 0xFF);
        this.write(utflen >>> 0 & 0xFF);
        for (i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.write(c);
                continue;
            }
            if (c > '\u07ff') {
                this.write(0xE0 | c >> 12 & 0xF);
                this.write(0x80 | c >> 6 & 0x3F);
                this.write(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.write(0xC0 | c >> 6 & 0x1F);
            this.write(0x80 | c >> 0 & 0x3F);
        }
    }

    public String toString() {
        return "fp=" + this.filePosition + ", bs=" + this.bufferStart + ", de=" + this.dataEnd + ", ds=" + this.dataSize + ", bl=" + this.buffer.length + ", readonly=" + this.readonly + ", bm=" + this.bufferModified;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void synch() throws IOException {
    }

    public String getLocation() {
        return this.location;
    }
}

