/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import javax.media.jai.JAI;
import org.apache.log4j.Logger;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GTRasterDataBinding;
import org.n52.wps.io.data.binding.complex.GeotiffBinding;
import org.n52.wps.io.datahandler.generator.AbstractGenerator;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;

public class GeotiffGenerator
extends AbstractGenerator {
    private static Logger LOGGER = Logger.getLogger(GeotiffGenerator.class);

    public GeotiffGenerator() {
        this.supportedIDataTypes.add(GTRasterDataBinding.class);
        this.supportedIDataTypes.add(GeotiffBinding.class);
    }

    @Override
    public InputStream generateStream(IData data, String mimeType, String schema) throws IOException {
        FileInputStream stream = null;
        if (data instanceof GTRasterDataBinding) {
            GridCoverage2D coverage = ((GTRasterDataBinding)data).getPayload();
            GeoTiffWriter geoTiffWriter = null;
            String tmpDirPath = System.getProperty("java.io.tmpdir");
            String fileName = tmpDirPath + File.separatorChar + "temp" + UUID.randomUUID() + ".tmp";
            File outputFile = new File(fileName);
            this.finalizeFiles.add(outputFile);
            try {
                geoTiffWriter = new GeoTiffWriter((Object)outputFile);
                this.writeGeotiff(geoTiffWriter, (GridCoverage)coverage);
                geoTiffWriter.dispose();
                stream = new FileInputStream(outputFile);
            }
            catch (IOException e) {
                LOGGER.error((Object)e.getMessage());
                throw new IOException("Could not create output due to an IO error");
            }
        }
        if (data instanceof GeotiffBinding) {
            File geotiff = ((GeotiffBinding)data).getPayload();
            try {
                stream = new FileInputStream(geotiff);
            }
            catch (FileNotFoundException e) {
                throw new IOException("Error while generating geotiff. Source file not found.");
            }
        }
        return stream;
    }

    private void writeGeotiff(GeoTiffWriter geoTiffWriter, GridCoverage coverage) {
        GeoTiffFormat format = new GeoTiffFormat();
        GeoTiffWriteParams wp = new GeoTiffWriteParams();
        wp.setCompressionMode(2);
        wp.setCompressionType("LZW");
        wp.setTilingMode(2);
        int width = ((GridCoverage2D)coverage).getRenderedImage().getWidth();
        int tileWidth = 1024;
        if (width < 2048) {
            tileWidth = new Double(Math.sqrt(width)).intValue();
        }
        wp.setTiling(tileWidth, tileWidth);
        ParameterValueGroup paramWrite = format.getWriteParameters();
        paramWrite.parameter(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString()).setValue((Object)wp);
        JAI.getDefaultInstance().getTileCache().setMemoryCapacity(0x10000000L);
        try {
            geoTiffWriter.write(coverage, paramWrite.values().toArray(new GeneralParameterValue[1]));
        }
        catch (IllegalArgumentException e1) {
            LOGGER.error((Object)e1);
            throw new RuntimeException(e1);
        }
        catch (IndexOutOfBoundsException e2) {
            LOGGER.error((Object)e2);
            throw new RuntimeException(e2);
        }
        catch (IOException e3) {
            LOGGER.error((Object)e3);
            throw new RuntimeException(e3);
        }
    }
}

