/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.geotools.feature.FeatureCollection;
import org.geotools.gml.producer.FeatureTransformer;
import org.n52.wps.PropertyDocument;
import org.n52.wps.io.SchemaRepository;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;
import org.n52.wps.io.datahandler.generator.AbstractGenerator;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GML2BasicGenerator
extends AbstractGenerator {
    private boolean featureTransformerIncludeBounding;
    private int featureTransformerDecimalPlaces;
    private static Logger LOGGER = Logger.getLogger(GML2BasicGenerator.class);

    public GML2BasicGenerator() {
        this.supportedIDataTypes.add(GTVectorDataBinding.class);
        this.featureTransformerIncludeBounding = false;
        this.featureTransformerDecimalPlaces = 4;
        for (PropertyDocument.Property property : this.properties) {
            if (property.getName().equalsIgnoreCase("featureTransformerIncludeBounding")) {
                this.featureTransformerIncludeBounding = new Boolean(property.getStringValue());
            }
            if (!property.getName().equalsIgnoreCase("featureTransformerDecimalPlaces")) continue;
            this.featureTransformerDecimalPlaces = new Integer(property.getStringValue());
        }
    }

    private void write(IData data, Writer writer) throws IOException {
        Iterator iter;
        FeatureCollection fc = ((GTVectorDataBinding)data).getPayload();
        if (fc == null || fc.size() == 0) {
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
            writer.write("<wfs:FeatureCollection xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\"/>");
            writer.flush();
        }
        Feature f = fc.features().next();
        FeatureType ft = f.getType();
        Map userData = f.getUserData();
        Object srs = userData.get("srs");
        String srsName = null;
        if (srs instanceof String) {
            srsName = (String)srs;
        } else if (srs instanceof CoordinateReferenceSystem && (iter = ((CoordinateReferenceSystem)srs).getIdentifiers().iterator()).hasNext()) {
            srsName = ((ReferenceIdentifier)iter.next()).toString();
        }
        FeatureTransformer tx = new FeatureTransformer();
        tx.setFeatureBounding(this.featureTransformerIncludeBounding);
        tx.setNumDecimals(this.featureTransformerDecimalPlaces);
        FeatureTransformer.FeatureTypeNamespaces ftNames = tx.getFeatureTypeNamespaces();
        HashMap<String, String> ftNamespaces = new HashMap<String, String>();
        String uri = ft.getName().getNamespaceURI();
        ftNames.declareNamespace(fc.getSchema(), fc.getSchema().getName().getLocalPart(), uri);
        if (ftNamespaces.containsKey(uri)) {
            String location = (String)ftNamespaces.get(uri);
            ftNamespaces.put(uri, location + "," + fc.getSchema().getName().getLocalPart());
        } else {
            ftNamespaces.put(uri, uri);
        }
        if (srsName != null) {
            tx.setSrsName(srsName);
        }
        String namespace = f.getType().getName().getNamespaceURI();
        String schemaLocation = SchemaRepository.getSchemaLocation(namespace);
        tx.addSchemaLocation(uri, schemaLocation);
        tx.addSchemaLocation("http://www.opengis.net/wfs", "http://schemas.opengis.net/wfs/1.0.0/WFS-basic.xsd");
        try {
            tx.transform((Object)fc, writer);
            writer.close();
        }
        catch (TransformerException e) {
            LOGGER.error((Object)e.getMessage());
            throw new IOException("Unable to generate GML");
        }
    }

    @Override
    public InputStream generateStream(IData data, String mimeType, String schema) throws IOException {
        File tempFile = File.createTempFile("gml2", "xml");
        this.finalizeFiles.add(tempFile);
        FileWriter fw = new FileWriter(tempFile);
        this.write(data, fw);
        try {
            fw.flush();
        }
        catch (IOException e) {
            LOGGER.warn((Object)"Attempted to flush stream although it was closed already.");
        }
        fw.close();
        FileInputStream is = new FileInputStream(tempFile);
        return is;
    }
}

