/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.data.binding.complex;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.n52.wps.io.IOUtils;
import org.n52.wps.io.data.IComplexData;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;

public class ShapefileBinding
implements IComplexData {
    private static Logger LOGGER = Logger.getLogger(ShapefileBinding.class);
    protected File shpFile;
    protected String mimeType;

    public ShapefileBinding(File shapeFile) {
        this.shpFile = shapeFile;
        this.mimeType = "application/x-zipped-shp";
    }

    @Override
    public File getPayload() {
        return this.shpFile;
    }

    @Override
    public Class getSupportedClass() {
        return File.class;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public File getZippedPayload() {
        String path = this.shpFile.getAbsolutePath();
        String baseName = path.substring(0, path.length() - ".shp".length());
        File shx = new File(baseName + ".shx");
        File dbf = new File(baseName + ".dbf");
        File prj = new File(baseName + ".prj");
        File zipped = null;
        try {
            zipped = IOUtils.zip(this.shpFile, shx, dbf, prj);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return zipped;
    }

    public GTVectorDataBinding getPayloadAsGTVectorDataBinding() {
        String dirName = "tmp" + UUID.randomUUID();
        File tempDir = null;
        try {
            ShapefileDataStore store = new ShapefileDataStore(this.shpFile.toURI().toURL());
            SimpleFeatureCollection features = store.getFeatureSource(store.getTypeNames()[0]).getFeatures();
            System.gc();
            tempDir.delete();
            return new GTVectorDataBinding((FeatureCollection)features);
        }
        catch (MalformedURLException e) {
            LOGGER.error((Object)"Something went wrong while creating data store.");
            e.printStackTrace();
            throw new RuntimeException("Something went wrong while creating data store.", e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Something went wrong while converting shapefile to FeatureCollection");
            e.printStackTrace();
            throw new RuntimeException("Something went wrong while converting shapefile to FeatureCollection", e);
        }
    }

    protected void finalize() {
        try {
            this.shpFile.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

