/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.client.demo;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.terradue.wps_hadoop.client.ExecuteRequestBuilder;
import com.terradue.wps_hadoop.client.ExecuteResponseAnalyser;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import net.opengis.wps.x100.CapabilitiesDocument;
import net.opengis.wps.x100.ExecuteDocument;
import net.opengis.wps.x100.ExecuteResponseDocument;
import net.opengis.wps.x100.InputDescriptionType;
import net.opengis.wps.x100.ProcessBriefType;
import net.opengis.wps.x100.ProcessDescriptionType;
import org.geotools.feature.FeatureCollection;
import org.n52.wps.client.WPSClientException;
import org.n52.wps.client.WPSClientSession;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WPSClientCL {
    @Parameter(names={"-h", "--help"}, description="Display help informations.")
    private boolean printHelp;
    @Parameter(names={"-u", "--url"}, description="The WPS url (e.g. \"http://localhost:8080/wps/WebProcessingService\").")
    private String wpsURL;
    @Parameter(names={"-p", "--process"}, description="The process ID to be used.")
    private String processID;
    @Parameter(names={"-c", "--capabilities"}, description="Display WPS GetCapabilities.")
    private boolean printCapabilities;
    @Parameter(names={"-d", "--describe"}, description="Display DescribeProcess for a given process ID.")
    private boolean printDescribeProcess;
    @Parameter(names={"-e", "--execute"}, description="Execute the given process ID with the eventually given parameter(s).")
    private boolean executeProcess;
    @Parameter(names={"-a", "--asynchronous"}, description="Set the execution as asynchronous.")
    private boolean asynchronous;
    @Parameter(names={"-t", "--time"}, description="Set the polling interval, in case of asynchronous execution, in milliseconds.")
    private long pollingTime = 2000L;
    @DynamicParameter(names={"-I", "--INPUT"}, description="WPS input parameter(s).")
    private HashMap<String, String> inputs = new HashMap();
    @Parameter(names={"-f", "--file"}, description="Path to a file where to write the WPS output.")
    private String outputFile;

    public void Main(String ... args) {
        JCommander jCommander = new JCommander((Object)this);
        jCommander.setProgramName(System.getProperty("app.name"));
        jCommander.parseWithoutValidation(args);
        if (this.printHelp) {
            jCommander.usage();
            System.exit(0);
        }
        try {
            ProcessDescriptionType describeProcessDocument;
            BufferedWriter out;
            if (this.printCapabilities) {
                if (this.wpsURL == null) {
                    System.err.println("Please provide a valid wps URL to query");
                    System.exit(-1);
                }
                System.err.println("WPS URL: " + this.wpsURL);
                try {
                    CapabilitiesDocument capabilitiesDocument = this.requestGetCapabilities(this.wpsURL);
                    if (this.outputFile != null) {
                        out = new BufferedWriter(new FileWriter(this.outputFile));
                        out.write(capabilitiesDocument.xmlText());
                        out.close();
                    } else {
                        System.out.println(capabilitiesDocument.xmlText());
                    }
                    System.exit(0);
                }
                catch (WPSClientException e) {
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
            if (this.printDescribeProcess) {
                if (this.processID == null) {
                    System.err.println("No Process ID has been specified. ");
                    System.exit(-1);
                }
                describeProcessDocument = this.requestDescribeProcess(this.wpsURL, this.processID);
                if (this.outputFile != null) {
                    out = new BufferedWriter(new FileWriter(this.outputFile));
                    out.write(describeProcessDocument.xmlText());
                    out.close();
                } else {
                    System.out.println(describeProcessDocument.xmlText());
                }
                System.exit(0);
            }
            if (this.executeProcess) {
                if (this.processID == null) {
                    System.err.println("No Process ID has been specified. ");
                    System.exit(-1);
                }
                describeProcessDocument = this.requestDescribeProcess(this.wpsURL, this.processID);
                ExecuteResponseAnalyser analyser = this.executeProcess(this.wpsURL, this.processID, describeProcessDocument, this.inputs);
                if (this.outputFile != null) {
                    BufferedWriter out2 = new BufferedWriter(new FileWriter(this.outputFile));
                    out2.write(analyser.getRawResponseDocument().toString());
                    out2.close();
                } else {
                    System.out.println(analyser.getRawResponseDocument().toString());
                }
                IData data = analyser.getComplexDataByIndex(0, GTVectorDataBinding.class);
                if (data == null) {
                    data = new LiteralStringBinding(analyser.getLiteralDataByIndex(0).getStringValue());
                }
                if (data instanceof GTVectorDataBinding) {
                    FeatureCollection featureCollection = ((GTVectorDataBinding)data).getPayload();
                    System.exit(0);
                } else if (data != null) {
                    System.exit(0);
                }
            } else {
                jCommander.usage();
            }
        }
        catch (WPSClientException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public CapabilitiesDocument requestGetCapabilities(String url) throws WPSClientException {
        ProcessBriefType[] processList;
        WPSClientSession wpsClient = WPSClientSession.getInstance();
        wpsClient.connect(url);
        CapabilitiesDocument capabilities = wpsClient.getWPSCaps(url);
        for (ProcessBriefType process : processList = capabilities.getCapabilities().getProcessOfferings().getProcessArray()) {
            System.err.println(process.getIdentifier().getStringValue());
        }
        return capabilities;
    }

    public ProcessDescriptionType requestDescribeProcess(String url, String processID) throws IOException {
        WPSClientSession wpsClient = WPSClientSession.getInstance();
        ProcessDescriptionType processDescription = wpsClient.getProcessDescription(url, processID);
        InputDescriptionType[] inputList = processDescription.getDataInputs().getInputArray();
        return processDescription;
    }

    public ExecuteResponseAnalyser executeProcess(String url, String processID, ProcessDescriptionType processDescription, HashMap<String, String> inputs) throws Exception {
        ExecuteRequestBuilder executeBuilder = new ExecuteRequestBuilder(processDescription);
        for (InputDescriptionType input : processDescription.getDataInputs().getInputArray()) {
            String[] inputValues;
            String inputName = input.getIdentifier().getStringValue();
            for (String inputValue : inputValues = inputs.get(inputName).split(",")) {
                if (input.getLiteralData() != null) {
                    if (!(inputValue instanceof String)) continue;
                    executeBuilder.addLiteralData(inputName, inputValue);
                    continue;
                }
                if (input.getComplexData() == null) continue;
                if (inputValue instanceof FeatureCollection) {
                    GTVectorDataBinding data = new GTVectorDataBinding((FeatureCollection)inputValue);
                    executeBuilder.addComplexData(inputName, (IData)data, "http://schemas.opengis.net/gml/3.1.1/base/feature.xsd", "UTF-8", "text/xml");
                }
                if (inputValue instanceof String) {
                    executeBuilder.addComplexDataReference(inputName, inputValue, "http://schemas.opengis.net/gml/3.1.1/base/feature.xsd", "UTF-8", "text/xml");
                }
                if (inputValue != null || input.getMinOccurs().intValue() <= 0) continue;
                throw new IOException("Property not set, but mandatory: " + inputName);
            }
        }
        executeBuilder.setMimeTypeForOutput("text/xml", "result");
        executeBuilder.setSchemaForOutput("http://schemas.opengis.net/gml/3.1.1/base/feature.xsd", "result");
        if (this.asynchronous) {
            executeBuilder.setStoreSupport(processDescription.getProcessOutputs().getOutputArray(0).getIdentifier().getStringValue());
        }
        ExecuteDocument execute = executeBuilder.getExecute();
        execute.getExecute().setService("WPS");
        WPSClientSession wpsClient = WPSClientSession.getInstance();
        Object responseObject = wpsClient.execute(url, execute);
        if (responseObject instanceof ExecuteResponseDocument) {
            IData data;
            ExecuteResponseDocument response = (ExecuteResponseDocument)responseObject;
            ExecuteResponseAnalyser analyser = new ExecuteResponseAnalyser(execute, response, processDescription);
            if (response.getExecuteResponse().isSetStatusLocation()) {
                String newUrl = response.getExecuteResponse().getStatusLocation();
                do {
                    Thread.sleep(this.pollingTime);
                    System.err.println("Polling Status Location: " + newUrl);
                } while (!(response = (ExecuteResponseDocument)(responseObject = wpsClient.executeViaGET(newUrl, ""))).getExecuteResponse().getStatus().isSetProcessSucceeded() && !response.getExecuteResponse().getStatus().isSetProcessPaused() && !response.getExecuteResponse().getStatus().isSetProcessAccepted() && !response.getExecuteResponse().getStatus().isSetProcessFailed());
                analyser = new ExecuteResponseAnalyser(execute, response, processDescription);
            }
            if (response.getExecuteResponse().getStatus().isSetProcessFailed()) {
                System.err.println("Process failed!");
                System.exit(-1);
            }
            if ((data = analyser.getComplexDataByIndex(0, GTVectorDataBinding.class)) == null) {
                data = new LiteralStringBinding(analyser.getLiteralDataByIndex(0).getStringValue());
            }
            return analyser;
        }
        throw new Exception("Exception: " + responseObject.toString());
    }

    public static void main(String[] args) {
        WPSClientCL client = new WPSClientCL();
        client.Main(args);
    }
}

