/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.geotools.data.BatchFeatureEvent;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureSource;
import org.geotools.data.Transaction;
import org.geotools.data.store.ContentEntry;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.identity.FeatureId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentState {
    protected Transaction tx;
    protected SimpleFeatureType featureType;
    protected int count = -1;
    protected ReferencedEnvelope bounds;
    protected ContentEntry entry;
    protected BatchFeatureEvent batchFeatureEvent;
    protected List<FeatureListener> listeners = Collections.synchronizedList(new ArrayList());
    protected Transaction.State callback = new Transaction.State(){

        public void setTransaction(Transaction transaction) {
        }

        public void addAuthorization(String AuthID) throws IOException {
        }

        public void commit() throws IOException {
            ContentState.this.fireBatchFeatureEvent(true);
        }

        public void rollback() throws IOException {
            ContentState.this.fireBatchFeatureEvent(false);
        }
    };

    public ContentState(ContentEntry entry) {
        this.entry = entry;
    }

    protected ContentState(ContentState state) {
        this(state.getEntry());
        this.featureType = state.featureType;
        this.count = state.count;
        this.bounds = state.bounds == null ? null : new ReferencedEnvelope(state.bounds);
        this.batchFeatureEvent = null;
    }

    public ContentEntry getEntry() {
        return this.entry;
    }

    public Transaction getTransaction() {
        return this.tx;
    }

    public void setTransaction(Transaction tx) {
        this.tx = tx;
        if (tx != Transaction.AUTO_COMMIT) {
            tx.putState(this.entry, this.callback);
        }
    }

    public final SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public final void setFeatureType(SimpleFeatureType featureType) {
        this.featureType = featureType;
    }

    public final int getCount() {
        return this.count;
    }

    public final void setCount(int count) {
        this.count = count;
    }

    public final ReferencedEnvelope getBounds() {
        return this.bounds;
    }

    public final void setBounds(ReferencedEnvelope bounds) {
        this.bounds = bounds;
    }

    public final void addListener(FeatureListener listener) {
        this.listeners.add(listener);
    }

    public final void removeListener(FeatureListener listener) {
        this.listeners.remove(listener);
    }

    public BatchFeatureEvent getBatchFeatureEvent() {
        return this.batchFeatureEvent;
    }

    public final boolean hasListener() {
        if (!this.listeners.isEmpty()) {
            return true;
        }
        return this.tx == Transaction.AUTO_COMMIT && this.entry.state.size() > 1;
    }

    public void fireFeatureUpdated(FeatureSource<?, ?> source, Feature feature, ReferencedEnvelope before) {
        if (this.listeners.isEmpty() && this.tx != Transaction.AUTO_COMMIT) {
            return;
        }
        Filter filter = this.idFilter(feature);
        ReferencedEnvelope bounds = new ReferencedEnvelope(feature.getBounds());
        bounds.expandToInclude(before);
        FeatureEvent event = new FeatureEvent(source, FeatureEvent.Type.CHANGED, bounds, filter);
        this.fireFeatureEvent(event);
    }

    public final void fireFeatureAdded(FeatureSource<?, ?> source, Feature feature) {
        if (this.listeners.isEmpty() && this.tx != Transaction.AUTO_COMMIT) {
            return;
        }
        Filter filter = this.idFilter(feature);
        ReferencedEnvelope bounds = new ReferencedEnvelope(feature.getBounds());
        FeatureEvent event = new FeatureEvent(source, FeatureEvent.Type.ADDED, bounds, filter);
        this.fireFeatureEvent(event);
    }

    public void fireFeatureRemoved(FeatureSource<?, ?> source, Feature feature) {
        if (this.listeners.isEmpty() && this.tx != Transaction.AUTO_COMMIT) {
            return;
        }
        Filter filter = this.idFilter(feature);
        ReferencedEnvelope bounds = new ReferencedEnvelope(feature.getBounds());
        FeatureEvent event = new FeatureEvent(source, FeatureEvent.Type.REMOVED, bounds, filter);
        this.fireFeatureEvent(event);
    }

    Filter idFilter(Feature feature) {
        FilterFactory ff = this.entry.dataStore.getFilterFactory();
        HashSet<FeatureId> fids = new HashSet<FeatureId>();
        fids.add(feature.getIdentifier());
        return ff.id(fids);
    }

    public final void fireFeatureEvent(FeatureEvent event) {
        if (this.tx == Transaction.AUTO_COMMIT) {
            this.entry.notifiyFeatureEvent(this, event);
        } else {
            if (this.batchFeatureEvent == null) {
                this.batchFeatureEvent = new BatchFeatureEvent(event.getFeatureSource());
            }
            this.batchFeatureEvent.add(event);
        }
        if (this.listeners.isEmpty()) {
            return;
        }
        for (FeatureListener listener : this.listeners) {
            try {
                listener.changed(event);
            }
            catch (Throwable t) {
                this.entry.dataStore.LOGGER.log(Level.WARNING, "Problem issuing batch feature event " + event, t);
            }
        }
    }

    public final void fireBatchFeatureEvent(boolean isCommit) {
        if (this.batchFeatureEvent == null) {
            return;
        }
        if (this.listeners.isEmpty()) {
            return;
        }
        if (isCommit) {
            this.batchFeatureEvent.setType(FeatureEvent.Type.COMMIT);
        } else {
            this.batchFeatureEvent.setType(FeatureEvent.Type.ROLLBACK);
        }
        for (FeatureListener listener : this.listeners) {
            try {
                listener.changed(this.batchFeatureEvent);
            }
            catch (Throwable t) {
                this.entry.dataStore.LOGGER.log(Level.WARNING, "Problem issuing batch feature event " + this.batchFeatureEvent, t);
            }
        }
        this.entry.notifiyFeatureEvent(this, this.batchFeatureEvent);
        this.batchFeatureEvent = null;
    }

    public void flush() {
        this.featureType = null;
        this.count = -1;
        this.bounds = null;
    }

    public void close() {
        this.featureType = null;
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
    }

    public ContentState copy() {
        return new ContentState(this);
    }
}

