/*
 * Decompiled with CFR 0.152.
 */
package smallgears.api.properties;

import lombok.NonNull;

public class Property {
    @NonNull
    private final String name;
    private Object value;

    public <S> S as(Class<S> type) {
        if (this.is(type)) {
            return type.cast(this.value());
        }
        throw new IllegalStateException("property value " + this.value() + " of type " + this.value().getClass() + " cannot be typed as " + type.getCanonicalName());
    }

    public boolean is(Class<?> type) {
        return type.isInstance(this.value());
    }

    @NonNull
    public String name() {
        return this.name;
    }

    public Object value() {
        return this.value;
    }

    public Property value(Object value) {
        this.value = value;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Property)) {
            return false;
        }
        Property other = (Property)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.name();
        String other$name = other.name();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Object this$value = this.value();
        Object other$value = other.value();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Property;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name();
        result = result * 59 + ($name == null ? 0 : $name.hashCode());
        Object $value = this.value();
        result = result * 59 + ($value == null ? 0 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "Property(" + this.name() + ", " + this.value() + ")";
    }

    private Property(@NonNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
    }

    public static Property prop(@NonNull String name) {
        return new Property(name);
    }

    private Property(@NonNull String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
        this.value = value;
    }

    public static Property prop(@NonNull String name, Object value) {
        return new Property(name, value);
    }
}

