package com.control_menu.custom;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.product.navigation.control.menu.ProductNavigationControlMenuEntry;
import com.liferay.product.navigation.control.menu.constants.ProductNavigationControlMenuCategoryKeys;


import org.gcube.common.portal.GCubePortalConstants;
import org.osgi.service.component.annotations.Component;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;

/**
 * @author netfarm-m2
 */
@Component(
        immediate = true,
        property = {
                "product.navigation.control.menu.category.key=" + ProductNavigationControlMenuCategoryKeys.TOOLS,
        "product.navigation.control.menu.category.order:Integer=0"
        },
        service = ProductNavigationControlMenuEntry.class
 )
public class CustomWorkspaceProductNavigationControlMenuEntry implements ProductNavigationControlMenuEntry {
    @Override
    public String getLabel(Locale locale) {
        return "Workspace";
    }

    @Override
    public String getLinkCssClass(HttpServletRequest httpServletRequest) {
        return "";
    }

    @Override
    public String getMarkupView(HttpServletRequest httpServletRequest) {
        return "";
    }

    @Override
    public String getURL(HttpServletRequest httpServletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay) httpServletRequest.getAttribute(WebKeys.THEME_DISPLAY);

        // Base portal URL (es. http://localhost:8080)
        String portalURL = themeDisplay.getPortalURL();

        // Vai sempre al gruppo "next"
        return portalURL + GCubePortalConstants.PREFIX_GROUP_URL + "/next" + GCubePortalConstants.USER_WORKSPACE_FRIENDLY_URL;
    }



    @Override
    public boolean includeBody(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        return false;
    }

    @Override
    public boolean includeIcon(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        return false;
    }

    @Override
    public boolean isPanelStateOpen(HttpServletRequest httpServletRequest, String key) {
        return false;
    }

    @Override
    public boolean isShow(HttpServletRequest httpServletRequest) throws PortalException {
        return true;
    }

    @Override
    public boolean isUseDialog() {
        return false;
    }

    @Override
    public void setPanelState(HttpServletRequest httpServletRequest, String key, String panelState) {

    }


    @Override
    public Map<String, Object> getData(HttpServletRequest httpServletRequest) {
        return Map.of();
    }

    @Override
    public String getIcon(HttpServletRequest request) {
        return "folder";
    }

    @Override
    public String getIconCssClass(HttpServletRequest httpServletRequest) {
        return "";
    }

    @Override
    public String getKey() {
        return "";
    }


    // TODO enter required service methods

}