package com.control_menu.custom;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.product.navigation.control.menu.ProductNavigationControlMenuEntry;
import com.liferay.product.navigation.control.menu.constants.ProductNavigationControlMenuCategoryKeys;
import org.gcube.common.portal.GCubePortalConstants;
import org.osgi.service.component.annotations.Component;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.Map;

@Component(
        immediate = true,
        property = {
                "product.navigation.control.menu.category.key=" + ProductNavigationControlMenuCategoryKeys.USER,
                "product.navigation.control.menu.category.order:Integer=1"
        },
        service = ProductNavigationControlMenuEntry.class
)
public class CustomNotificationControlMenuEntry implements ProductNavigationControlMenuEntry {

    @Override
    public String getLabel(Locale locale) {
        return "Notifications";
    }

    @Override
    public String getLinkCssClass(HttpServletRequest httpServletRequest) {
        return "";
    }

    @Override
    public String getMarkupView(HttpServletRequest httpServletRequest) {
        return "";
    }

    @Override
    public String getURL(HttpServletRequest httpServletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay) httpServletRequest.getAttribute(WebKeys.THEME_DISPLAY);

        // Base portal URL (es. http://localhost:8080)
        String portalURL = themeDisplay.getPortalURL();

        // Vai sempre al gruppo "next"
        return portalURL + GCubePortalConstants.PREFIX_GROUP_URL + "/next" + GCubePortalConstants.USER_NOTIFICATION_FRIENDLY_URL;
    }


    @Override
    public boolean includeBody(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try (InputStream is = getClass().getClassLoader().getResourceAsStream("custom-notification.html")) {
            if (is != null) {
                String html = new String(is.readAllBytes(), java.nio.charset.StandardCharsets.UTF_8);
                response.getWriter().println(html);
            }
        }
        return true;
    }




    @Override
    public boolean includeIcon(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        return false;
    }

    @Override
    public boolean isPanelStateOpen(HttpServletRequest httpServletRequest, String key) {
        return false;
    }

    @Override
    public boolean isShow(HttpServletRequest httpServletRequest) throws PortalException {
        return true;
    }

    @Override
    public boolean isUseDialog() {
        return false;
    }

    @Override
    public void setPanelState(HttpServletRequest httpServletRequest, String key, String panelState) {

    }


    @Override
    public Map<String, Object> getData(HttpServletRequest httpServletRequest) {
        return Map.of();
    }

    @Override
    public String getIcon(HttpServletRequest request) {
        return "bell-on";
    }

    @Override
    public String getIconCssClass(HttpServletRequest httpServletRequest) {
        return "";
    }

    @Override
    public String getKey() {
        return "";
    }


    // TODO enter required service methods

}