package com.control_menu.custom;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.product.navigation.control.menu.ProductNavigationControlMenuEntry;
import com.liferay.product.navigation.control.menu.constants.ProductNavigationControlMenuCategoryKeys;
import org.osgi.service.component.annotations.Component;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

@Component(
        immediate = true,
        property = {
                "product.navigation.control.menu.category.key=" + ProductNavigationControlMenuCategoryKeys.USER,
                "product.navigation.control.menu.category.order:Integer=10"
        },
        service = ProductNavigationControlMenuEntry.class
)
public class CustomGoToProductNavigationControlMenuEntry implements ProductNavigationControlMenuEntry {

    @Override
    public String getLabel(Locale locale) {
        return "Sites";
    }

    @Override
    public String getMarkupView(HttpServletRequest request) {
        return "";
    }

    @Override
    public String getURL(HttpServletRequest request) {
        return "javascript:void(0);";
    }

    @Override
    public String getLinkCssClass(HttpServletRequest request) {
        return "control-menu-nav-link";
    }

    @Override
    public boolean includeBody(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute(WebKeys.THEME_DISPLAY);
        User user = themeDisplay.getUser();

        try (InputStream is = getClass().getClassLoader().getResourceAsStream("sites-links.html")) {
            if (is != null) {
                String html = new String(is.readAllBytes(), StandardCharsets.UTF_8);

                List<Group> siteGroups = user.getMySiteGroups();

                String sitesList = siteGroups.stream()
                        .map(group -> {
                            try {
                                String siteName = HtmlUtil.escape(group.getDescriptiveName(themeDisplay.getLocale()));
                                String siteUrl = themeDisplay.getPortalURL() + group.getPathFriendlyURL(false, themeDisplay)
                                        + group.getFriendlyURL();
                                return "<li><a href=\"" + siteUrl + "\">" + siteName + "</a></li>";
                            } catch (PortalException e) {
                                throw new RuntimeException(e);
                            }
                        })
                        .collect(Collectors.joining());

                if (sitesList.isEmpty()) {
                    sitesList = "<li><span>No sites available</span></li>";
                }

                html = html.replace("{{sitesList}}", sitesList);

                response.getWriter().println(html);
            }
        } catch (PortalException e) {
            throw new IOException(e);
        }

        return true;
    }

    @Override
    public boolean includeIcon(HttpServletRequest request, HttpServletResponse response) {
        return false;
    }

    @Override
    public boolean isPanelStateOpen(HttpServletRequest request, String key) {
        return false;
    }

    @Override
    public boolean isShow(HttpServletRequest request) {
        ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute(WebKeys.THEME_DISPLAY);
        return themeDisplay.isSignedIn();
    }

    @Override
    public boolean isUseDialog() {
        return false;
    }

    @Override
    public void setPanelState(HttpServletRequest request, String key, String panelState) {}

    @Override
    public Map<String, Object> getData(HttpServletRequest request) {
        // Cambiato qa-id unico per evitare conflitti
        return Map.of("qa-id", "custom_sites_links");
    }

    @Override
    public String getIcon(HttpServletRequest request) {
        return "globe";
    }

    @Override
    public String getIconCssClass(HttpServletRequest request) {
        return "";
    }

    @Override
    public String getKey() {
        return "custom-sites-links";
    }
}
