//package org.gcube.mongodb.access;
//
//import java.util.ArrayList;
//import java.util.List;
//
//import org.gcube.common.scope.api.ScopeProvider;
//import org.gcube.mongodb.driver.MongoClientInstance;
//import org.gcube.mongodb.driver.MongoConfiguration;
//import com.mongodb.MongoClientOptions;
//import com.mongodb.ServerAddress;
//
//public class MongoStart {
//	
//	private String serviceClass;
//	private String serviceName;
//	private List<String> servers;
//	private String u;
//	private String p;
//	private String db;
//	private MongoClientOptions options;
//	
//	public MongoStart(String serviceClass, String serviceName){
//		this.serviceClass=serviceClass;
//		this.serviceName=serviceName;
//	}
//	
//	public MongoStart(List <String> servers, String user, String  pwd, String dbName, MongoClientOptions options){
//		setServers(servers);
//		setU(user);
//		setP(pwd);
//		setOptions(options);
//		setDb(dbName);
//	}
//	
//	public MongoClientInstance getClient(){
//		if(serviceClass != null && serviceName != null){
//			if (ScopeProvider.instance.get() == null) throw new RuntimeException("The scope provider is null ");
//			GCubeClient gc= new GCubeClient(serviceClass, serviceName);
//			MongoConfiguration conf= gc.buildConfiguration();
//			return MongoClientInstance.getInstance(conf);
//		}else if (servers != null && !servers.isEmpty()){
//			List<ServerAddress> srvList=new ArrayList<ServerAddress>();
//			for(String srv : servers){
//					srvList.add(new ServerAddress(srv));
//			}
//			MongoConfiguration conf= new MongoConfiguration(getU(), getP(), getDb(), srvList, options);
//			return MongoClientInstance.getInstance(conf);
//		}else{
//			throw new IllegalArgumentException("Input parameters are incorrect ");
//		}
//	}
//	
//	public String getServiceClass() {
//		return serviceClass;
//	}
//
//	public void setServiceClass(String serviceClass) {
//		this.serviceClass = serviceClass;
//	}
//
//	public String getServiceName() {
//		return serviceName;
//	}
//
//	public void setServiceName(String serviceName) {
//		this.serviceName = serviceName;
//	}
//
//	public List<String> getServers() {
//		return servers;
//	}
//
//	public void setServers(List<String> servers) {
//		this.servers = servers;
//	}
//
//	public String getU() {
//		return u;
//	}
//
//	public void setU(String u) {
//		this.u = u;
//	}
//
//	public String getP() {
//		return p;
//	}
//
//	public void setP(String p) {
//		this.p = p;
//	}
//
//	public MongoClientOptions getOptions() {
//		return options;
//	}
//
//	public void setOptions(MongoClientOptions options) {
//		this.options = options;
//	}
//
//	public String getDb() {
//		return db;
//	}
//
//	public void setDb(String db) {
//		this.db = db;
//	}
//
//
//}
