/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.socialmail;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.sun.mail.util.MailSSLSocketFactory;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.UUID;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.core.util.GenderType;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.common.portal.PortalContext;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portal.databook.shared.Like;
import org.gcube.portal.databook.shared.ex.ColumnNameNotFoundException;
import org.gcube.portal.databook.shared.ex.FeedIDNotFoundException;
import org.gcube.portal.databook.shared.ex.FeedTypeNotFoundException;
import org.gcube.portal.databook.shared.ex.PrivacyLevelTypeNotFoundException;
import org.gcube.portal.notifications.thread.CommentNotificationsThread;
import org.gcube.portal.notifications.thread.LikeNotificationsThread;
import org.gcube.portal.socialmail.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class PeriodicTask
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger(PeriodicTask.class);
    private DatabookStore socialStore;
    private String host;
    private String mailserver_username;
    private String password;
    private String portalName;

    public PeriodicTask(DatabookStore store, String portalName, String host, String mailserver_username, String password) {
        this.socialStore = store;
        this.portalName = portalName;
        this.host = host;
        this.mailserver_username = mailserver_username;
        this.password = password;
    }

    @Override
    public void run() {
        this.check(this.portalName, this.host, this.mailserver_username, this.password);
    }

    private ASLSession getFakeASLSession(String emailAddress) {
        String sessionID = UUID.randomUUID().toString();
        PortalContext context = PortalContext.getConfiguration();
        String scope = "/" + context.getInfrastructureName();
        String username = "";
        try {
            long companyId = OrganizationsUtil.getCompany().getCompanyId();
            User user = UserLocalServiceUtil.getUserByEmailAddress((long)companyId, (String)emailAddress);
            username = user.getScreenName();
            SessionManager.getInstance().getASLSession(sessionID, username).setScope(scope);
            String fullName = user.getFirstName() + " " + user.getLastName();
            String email = user.getEmailAddress();
            String thumbnailURL = "/image/user_male_portrait?img_id=" + user.getPortraitId();
            boolean isMale = user.isMale();
            SessionManager.getInstance().getASLSession(sessionID, username).setUserFullName(fullName);
            SessionManager.getInstance().getASLSession(sessionID, username).setUserEmailAddress(email);
            SessionManager.getInstance().getASLSession(sessionID, username).setUserAvatarId(thumbnailURL);
            SessionManager.getInstance().getASLSession(sessionID, username).setUserGender(isMale ? GenderType.MALE : GenderType.FEMALE);
            _log.debug("Created fakesession for user " + username + " email=" + emailAddress);
        }
        catch (PortalException | SystemException e) {
            _log.error("Exception while trying to get the user from email address: " + e.getMessage());
        }
        return SessionManager.getInstance().getASLSession(sessionID, username);
    }

    public void check(String portalName, String host, String user, String password) {
        try {
            MailSSLSocketFactory sf = null;
            try {
                sf = new MailSSLSocketFactory();
            }
            catch (GeneralSecurityException e) {
                e.printStackTrace();
            }
            sf.setTrustAllHosts(true);
            Properties pop3Props = new Properties();
            pop3Props.setProperty("mail.pop3.ssl.enable", "true");
            pop3Props.setProperty("mail.protocol.ssl.trust", host);
            pop3Props.put("mail.pop3s.ssl.socketFactory", sf);
            pop3Props.setProperty("mail.pop3s.port", "995");
            Session emailSession = Session.getDefaultInstance((Properties)pop3Props);
            emailSession.setDebug(false);
            Store store = emailSession.getStore("pop3s");
            _log.debug("Trying to connect to " + host + ", user=" + user + " passwd (first 3 char)=" + password.substring(0, 3) + "******");
            store.connect(host, user, password);
            Folder emailFolder = store.getFolder("INBOX");
            emailFolder.open(2);
            Message[] messages = emailFolder.getMessages();
            _log.debug("Found " + messages.length + " new messages ...");
            for (Message message : messages) {
                _log.info("--------------- FOUND EMAIL ------------------");
                String subject = message.getSubject();
                _log.debug("Parsing email of " + message.getFrom()[0] + " with subject: " + subject);
                String feedId = PeriodicTask.extractFeedId((Message)message);
                String commentText = PeriodicTask.extractText((String)portalName, (String)feedId, (Message)message);
                _log.info("Extracted id: " + feedId + " text=" + commentText);
                String escapedCommentText = Utils.escapeHtmlAndTransformUrl((String)commentText);
                Address[] froms = message.getFrom();
                String emailAddress = froms == null ? null : ((InternetAddress)froms[0]).getAddress();
                ASLSession fakeSession = this.getFakeASLSession(emailAddress);
                if (escapedCommentText.trim().compareTo("") == 0) {
                    _log.debug("Found favorite/subscription for feed with subject: " + subject);
                    this.favoriteFeed(feedId, fakeSession);
                } else {
                    Comment comment = new Comment(UUID.randomUUID().toString(), fakeSession.getUsername(), new Date(), feedId, escapedCommentText, fakeSession.getUserFullName(), fakeSession.getUserAvatarId());
                    _log.debug("The EscapedCommentText =>" + escapedCommentText);
                    boolean commentCommitResult = false;
                    try {
                        if (this.socialStore.addComment(comment)) {
                            commentCommitResult = true;
                        }
                    }
                    catch (FeedIDNotFoundException e) {
                        _log.error("Related post not found for this comment " + e.getMessage());
                        e.printStackTrace();
                    }
                    if (commentCommitResult) {
                        this.notifyUsersInvolved(comment, escapedCommentText, feedId, fakeSession);
                    }
                }
                message.setFlag(Flags.Flag.DELETED, true);
                _log.debug("Marked DELETE for message: " + subject);
            }
            emailFolder.close(true);
            store.close();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void favoriteFeed(String feedId, ASLSession fakeSession) {
        if (feedId == null || feedId.compareTo("") == 0) {
            _log.warn("Found email with no feedId from " + fakeSession.getUserEmailAddress() + ". Going to trash it");
            return;
        }
        Like like = new Like(UUID.randomUUID().toString(), fakeSession.getUsername(), new Date(), feedId, fakeSession.getUserFullName(), fakeSession.getUserAvatarId());
        boolean likeCommitResult = false;
        try {
            if (this.socialStore.like(like)) {
                // empty if block
            }
            likeCommitResult = true;
        }
        catch (FeedIDNotFoundException e) {
            _log.error("Related post not found for this like " + e.getMessage());
            e.printStackTrace();
        }
        if (likeCommitResult) {
            try {
                Feed feed = this.socialStore.readFeed(feedId);
                String feedOwnerId = feed.getEntityId();
                boolean isAppFeed = feed.isApplicationFeed();
                ApplicationNotificationsManager nm = new ApplicationNotificationsManager(fakeSession);
                if (!fakeSession.getUsername().equals(feedOwnerId) && !isAppFeed) {
                    boolean result = nm.notifyLikedFeed(feedOwnerId, feedId, "");
                    _log.trace("Like Notification to post owner added? " + result);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void notifyUsersInvolved(Comment comment, String commentText, String feedId, ASLSession fakeSession) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, FeedIDNotFoundException, ColumnNameNotFoundException {
        Feed feed = this.socialStore.readFeed(feedId);
        String feedOwnerId = feed.getEntityId();
        boolean isAppFeed = feed.isApplicationFeed();
        ApplicationNotificationsManager nm = new ApplicationNotificationsManager(fakeSession);
        if (!fakeSession.getUsername().equals(feedOwnerId) && !isAppFeed) {
            boolean result = nm.notifyOwnCommentReply(feedOwnerId, feedId, commentText);
            _log.trace("Comment Notification to post owner added? " + result);
        }
        ArrayList favorites = this.getAllLikesByFeed(feedId);
        Thread likesThread = new Thread((Runnable)new LikeNotificationsThread(commentText, (NotificationsManager)nm, favorites, feedOwnerId));
        likesThread.start();
        Thread commentsNotificationthread = new Thread((Runnable)new CommentNotificationsThread(this.socialStore, fakeSession.getUsername(), comment.getFeedid(), commentText, (NotificationsManager)nm, feedOwnerId, favorites));
        commentsNotificationthread.start();
    }

    public ArrayList<Like> getAllLikesByFeed(String feedid) {
        _log.trace("Asking likes for " + feedid);
        ArrayList toReturn = (ArrayList)this.socialStore.getAllLikesByFeed(feedid);
        return toReturn;
    }

    private static String extractFeedId(Message message) throws MessagingException {
        Address[] emails = message.getRecipients(MimeMessage.RecipientType.TO);
        String toParse = emails[0].toString();
        int plus = toParse.indexOf(43);
        int at = toParse.indexOf(64);
        if (plus == -1) {
            return null;
        }
        return toParse.substring(plus + 1, at);
    }

    private static String extractText(String portalName, String subjectId, Message message) throws Exception {
        Object messageContent = message.getContent();
        String toParse = null;
        String SEPARATOR = "- Write ABOVE THIS LINE to post a reply via email, reply with empty msg to subscribe -".substring(0, 23);
        if (messageContent instanceof Multipart) {
            _log.debug("Found Multipart Message, getting text part ... looking for separator " + SEPARATOR);
            Multipart multipart = (Multipart)messageContent;
            BodyPart part = multipart.getBodyPart(0);
            part.toString();
            toParse = part.getContent().toString();
        } else {
            _log.debug("Found g text/plain Message, getting text");
            toParse = messageContent.toString();
        }
        String[] lines = toParse.split(System.getProperty("line.separator"));
        int until = -1;
        for (int i = 0; i < lines.length; ++i) {
            if (!lines[i].contains(SEPARATOR)) continue;
            until = i;
            break;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < until; ++i) {
            if (!(lines[i].contains(portalName) || lines[i].contains(subjectId) || lines[i].startsWith("> ") && lines[i].trim().length() < 2)) {
                sb.append(lines[i]);
            }
            if (i == until - 1) continue;
            sb.append("\n");
        }
        return sb.toString().trim();
    }
}

