/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.notifier.impl;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.xml.namespace.QName;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.notifier.impl.entities.Consumer;
import org.gcube.informationsystem.notifier.impl.entities.Producer;
import org.gcube.informationsystem.notifier.util.RegistrationEventHandlerImpl;
import org.gcube.informationsystem.notifier.util.TopicMapping;
import org.globus.wsrf.ResourceException;

public class NotifierResource
extends GCUBEWSResource {
    private Hashtable<String, TopicMapping<Producer, Consumer, RegistrationEventHandlerImpl>> topicMappingList;
    private final GCUBELog logger = new GCUBELog(NotifierResource.class);

    public void initialise(Object ... o) throws ResourceException {
        try {
            this.topicMappingList = new Hashtable();
        }
        catch (Exception e) {
            this.logger.error((Object)"Runtime exception", (Throwable)e);
            throw new ResourceException((Throwable)e);
        }
    }

    public synchronized TopicMapping<Producer, Consumer, RegistrationEventHandlerImpl> getTopicMappingByQName(QName topic) throws Exception {
        this.logger.trace((Object)("searching for topic " + topic));
        return this.topicMappingList.get(topic.toString());
    }

    public synchronized Hashtable<String, TopicMapping<Producer, Consumer, RegistrationEventHandlerImpl>> getTopicMappingList() {
        return this.topicMappingList;
    }

    public synchronized void setTopicMappingList(Hashtable<String, TopicMapping<Producer, Consumer, RegistrationEventHandlerImpl>> listTopicMapping) {
        this.topicMappingList = listTopicMapping;
    }

    public synchronized boolean isTopicPresent(QName topic) {
        return this.topicMappingList.get(topic.toString()) != null;
    }

    public synchronized void addTopicMapping(TopicMapping<Producer, Consumer, RegistrationEventHandlerImpl> topicMapping) {
        this.topicMappingList.put(topicMapping.getTopic().toString(), topicMapping);
    }

    public synchronized List<String> getListTopic() {
        ArrayList<String> topicList = new ArrayList<String>();
        for (TopicMapping<Producer, Consumer, RegistrationEventHandlerImpl> t : this.topicMappingList.values()) {
            topicList.add(t.getTopic().toString());
        }
        return topicList;
    }
}

