/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.notifier.impl;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.notifier.impl.NotifierContext;
import org.gcube.informationsystem.notifier.impl.NotifierResource;
import org.gcube.informationsystem.notifier.impl.ServiceContext;
import org.gcube.informationsystem.notifier.impl.entities.Consumer;
import org.gcube.informationsystem.notifier.impl.entities.Producer;
import org.gcube.informationsystem.notifier.stubs.IsOngoingRequest;
import org.gcube.informationsystem.notifier.stubs.IsOngoingResponse;
import org.gcube.informationsystem.notifier.stubs.ListTopics;
import org.gcube.informationsystem.notifier.stubs.ListTopicsResponse;
import org.gcube.informationsystem.notifier.stubs.RegisterTopicMessage;
import org.gcube.informationsystem.notifier.stubs.RemoveNotifier;
import org.gcube.informationsystem.notifier.stubs.RemoveNotifierResponse;
import org.gcube.informationsystem.notifier.stubs.RemoveSubscriber;
import org.gcube.informationsystem.notifier.stubs.RemoveSubscriberResponse;
import org.gcube.informationsystem.notifier.stubs.RemoveSubscriptionResponse;
import org.gcube.informationsystem.notifier.stubs.SubscribeMessage;
import org.gcube.informationsystem.notifier.stubs.SubscribeToTopicResponse;
import org.gcube.informationsystem.notifier.stubs.UnregisterTopicResponse;
import org.gcube.informationsystem.notifier.thread.RegisterTopicThread;
import org.gcube.informationsystem.notifier.util.EPR;
import org.gcube.informationsystem.notifier.util.RegistrationEventHandlerImpl;
import org.gcube.informationsystem.notifier.util.TopicMapping;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.security.SecurityManager;

public class Notifier {
    protected final GCUBELog logger = new GCUBELog((Object)this);

    public SubscribeToTopicResponse subscribeToTopic(SubscribeMessage message) throws GCUBEFault {
        List<EndpointReferenceType> notifiersEprs;
        this.logger.info((Object)"subscribeToTopic method");
        long start = System.currentTimeMillis();
        try {
            TopicMapping<Producer, Consumer, RegistrationEventHandlerImpl> topicMapping;
            NotifierResource resource = this.getResource();
            if (resource.isTopicPresent(QName.valueOf(message.getTopic()))) {
                topicMapping = resource.getTopicMappingByQName(QName.valueOf(message.getTopic()));
            } else {
                topicMapping = new TopicMapping(QName.valueOf(message.getTopic()));
                topicMapping.setRegistrationEventHandler(new RegistrationEventHandlerImpl(QName.valueOf(message.getTopic())));
                resource.addTopicMapping(topicMapping);
            }
            Consumer consumer = new Consumer(message.getEndpointReference());
            consumer.setPrecondition(message.getPrecondition());
            consumer.setSelection(message.getSelection());
            topicMapping.addConsumer(consumer);
            resource.store();
            notifiersEprs = topicMapping.getProducers();
            this.logger.info((Object)("subscribed " + message.getEndpointReference() + " for the topic " + message.getTopic()));
            this.logger.debug((Object)("there are " + resource.getTopicMappingList().size() + " in the array"));
            this.logger.debug((Object)("there are " + notifiersEprs.size() + "producer for this topic"));
        }
        catch (Exception e) {
            this.logger.error((Object)("error subscribing " + message.getEndpointReference() + " for the topic " + message.getTopic()), (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error subscribing " + message.getEndpointReference() + " for the topic " + message.getTopic()});
        }
        long end = System.currentTimeMillis();
        this.logger.debug((Object)("SubscribeToTopic finished his work with topic " + message.getTopic() + " in " + (end - start) + " ms"));
        EndpointReferenceType[] notifierEprArray = notifiersEprs.toArray(new EndpointReferenceType[notifiersEprs.size()]);
        this.logger.debug((Object)("producer address returned are " + notifierEprArray.length));
        for (EndpointReferenceType epr : notifierEprArray) {
            this.logger.debug((Object)("returned subscription resource is: " + epr));
        }
        return new SubscribeToTopicResponse(notifierEprArray);
    }

    public RemoveSubscriptionResponse removeSubscription(SubscribeMessage message) throws GCUBEFault {
        try {
            this.logger.debug((Object)("removing subscription " + message.getTopic().toString() + " with precondition" + message.getPrecondition()));
            EndpointReferenceType subscriberEPR = message.getEndpointReference();
            if (subscriberEPR == null || message.getTopic() == null || message.getTopic().compareTo("") == 0) {
                throw ServiceContext.getContext().getDefaultException("MissingInputParamters", null).toFault(new String[]{"MissingInputParamters"});
            }
            QName topic = QName.valueOf(message.getTopic());
            NotifierResource resource = this.getResource();
            TopicMapping<Producer, Consumer, RegistrationEventHandlerImpl> topicMapping = resource.getTopicMappingByQName(topic);
            Consumer consumer = new Consumer(subscriberEPR);
            consumer.setPrecondition(message.getPrecondition());
            consumer.setSelection(message.getSelection());
            topicMapping.removeConsumer(consumer);
            if (topicMapping.getConsumerList().size() == 0 && topicMapping.getProducerList().size() == 0) {
                resource.getTopicMappingList().remove(topicMapping.getTopic().toString());
            }
            this.logger.debug((Object)"the subscription has been removed without errors");
        }
        catch (Exception e) {
            this.logger.error((Object)(" Error removing subscription " + e));
            throw ServiceContext.getContext().getDefaultException(" Error removing subscription", e).toFault(new String[]{" Error removing subscription"});
        }
        return new RemoveSubscriptionResponse();
    }

    public String registerTopic(RegisterTopicMessage message) throws GCUBEFault {
        this.logger.debug((Object)("registerTopic(" + message.getVectorTopic().length + " topics) called  "));
        EndpointReferenceType notifierEPR = message.getEndpointReference();
        RegisterTopicThread rtt = new RegisterTopicThread(message.getVectorTopic(), notifierEPR);
        ServiceContext.getContext().setScope(rtt, ServiceContext.getContext().getScope());
        rtt.start();
        return "";
    }

    public synchronized UnregisterTopicResponse unregisterTopic(RegisterTopicMessage message) throws GCUBEFault {
        NotifierResource resource;
        this.logger.info((Object)"unregister topic method");
        EndpointReferenceType notifierEpr = message.getEndpointReference();
        boolean hasErrors = false;
        String errorsString = "";
        try {
            resource = this.getResource();
        }
        catch (Exception e) {
            this.logger.error((Object)"error retrieving resource");
            throw new GCUBEFault((Throwable)e, new String[]{"error retrieving resource"});
        }
        if (notifierEpr == null) {
            throw ServiceContext.getContext().getDefaultException(" Error taking parameters", null).toFault(new String[]{"Error taking parameters"});
        }
        for (String topicString : message.getVectorTopic()) {
            try {
                TopicMapping<Producer, Consumer, RegistrationEventHandlerImpl> topicMapping = resource.getTopicMappingByQName(QName.valueOf(topicString));
                topicMapping.removeProducer(new Producer(notifierEpr));
                this.logger.debug((Object)("removed producer with epr " + notifierEpr + " from " + topicMapping.getTopic().toString()));
                if (topicMapping.getConsumerList().size() != 0 || topicMapping.getProducerList().size() != 0) continue;
                resource.getTopicMappingList().remove(topicMapping.getTopic().toString());
            }
            catch (Exception e) {
                this.logger.error((Object)("error unregistering the producer to the topic " + topicString + " for " + notifierEpr), (Throwable)e);
                hasErrors = true;
                errorsString = errorsString + topicString + " for " + notifierEpr;
            }
        }
        resource.store();
        if (hasErrors) {
            throw new GCUBEFault(new String[]{"error unregistering the producer for the topic " + errorsString});
        }
        return new UnregisterTopicResponse();
    }

    public ListTopicsResponse listTopics(ListTopics topics) throws GCUBEFault {
        ListTopicsResponse topicList = new ListTopicsResponse();
        try {
            List<String> listTopic = this.getResource().getListTopic();
            topicList.setTopicList(listTopic.toArray(new String[listTopic.size()]));
            this.logger.info((Object)("the topic registered are " + topicList.getTopicList().length));
        }
        catch (Exception e) {
            throw ServiceContext.getContext().getDefaultException(" Error Listing Topics ", e).toFault(new String[]{"Error Listing Topics"});
        }
        return topicList;
    }

    public String[] listTopicForNotifier(EndpointReferenceType epr) throws GCUBEFault {
        ArrayList topicList = new ArrayList();
        return topicList.toArray(new String[0]);
    }

    public RemoveNotifierResponse removeNotifier(RemoveNotifier notifiers) throws GCUBEFault {
        try {
            NotifierResource res = this.getResource();
            for (TopicMapping<Producer, Consumer, RegistrationEventHandlerImpl> topic : res.getTopicMappingList().values()) {
                for (EndpointReferenceType epr : notifiers.getEndpointReference()) {
                    topic.removeProducer(new Producer(epr));
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"error removing notifiers", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException(" Error Removing Notifiers ", e).toFault(new String[]{"Error Removing Notifiers"});
        }
        return new RemoveNotifierResponse();
    }

    public RemoveSubscriberResponse removeSubscriber(RemoveSubscriber subscribers) throws GCUBEFault {
        try {
            NotifierResource res = this.getResource();
            for (TopicMapping<Producer, Consumer, RegistrationEventHandlerImpl> topic : res.getTopicMappingList().values()) {
                for (EndpointReferenceType epr : subscribers.getEndpointReference()) {
                    topic.removeConsumer(new Consumer(epr));
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"error removing subscribers", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException(" Error Removing subscribers ", e).toFault(new String[]{"Error Removing subscribers"});
        }
        return new RemoveSubscriberResponse();
    }

    public EndpointReferenceType[] getSubscribersForTopic(String topic) throws GCUBEFault {
        try {
            TopicMapping<Producer, Consumer, RegistrationEventHandlerImpl> topicMapping = this.getResource().getTopicMappingByQName(QName.valueOf(topic));
            EndpointReferenceType[] subscribers = topicMapping.getConsumers().toArray(new EndpointReferenceType[0]);
            return subscribers;
        }
        catch (RemoteException e) {
            this.logger.error((Object)"error retrieving subscribers for this topic", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException(" Error Getting Subscribers ", e).toFault(new String[]{"Error Getting Subscribers "});
        }
        catch (Exception e) {
            this.logger.error((Object)"error retrieving subscribers for this topic", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException(" Error Getting Subscribers ", e).toFault(new String[]{"Error Getting Subscribers "});
        }
    }

    protected NotifierResource getResource() throws RemoteException {
        GCUBEWSResource resource = null;
        try {
            resource = NotifierContext.getPortTypeContext().getWSHome().find((ResourceKey)NotifierContext.getContext().makeKey("NotifierResource_" + ServiceContext.getContext().getScope().toString().replace("/", "_")));
        }
        catch (Exception e) {
            this.logger.error((Object)" Unable to access resource", (Throwable)e);
        }
        NotifierResource notifierResource = (NotifierResource)resource;
        return notifierResource;
    }

    public void logSecurityInfo(String methodName) {
        this.logger.info((Object)(" Security info for method " + methodName));
        String identity = SecurityManager.getManager().getCaller();
        this.logger.info((Object)(" The caller is: " + identity));
    }

    public IsOngoingResponse isOngoing(IsOngoingRequest request) throws RemoteException {
        this.logger.debug((Object)"isOngoing call - START");
        NotifierResource resource = this.getResource();
        boolean[] mask = new boolean[request.getItemList().length];
        for (int i = 0; i < request.getItemList().length; ++i) {
            try {
                TopicMapping<Producer, Consumer, RegistrationEventHandlerImpl> topicMapping = resource.getTopicMappingByQName(QName.valueOf(request.getItemList(i).getTopic()));
                Producer p = topicMapping.getProducerList().get(topicMapping.getProducerList().indexOf(new EPR(request.getItemList(i).getEndpointReference())));
                mask[i] = p.isSubscribed();
                continue;
            }
            catch (Exception e) {
                this.logger.warn((Object)"problem checking the ongoing registration/unregistration (the topic isn't in the map)");
                mask[i] = false;
            }
        }
        for (boolean b : mask) {
            this.logger.trace((Object)b);
        }
        this.logger.debug((Object)"isOngoing call - END");
        return new IsOngoingResponse(mask);
    }
}

