/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.um.ldap.user.service;

import it.eng.rdlab.um.ldap.service.exceptions.LdapManagerException;
import it.eng.rdlab.um.ldap.user.bean.LdapUserModel;
import it.eng.rdlab.um.ldap.user.bean.LdapUserModelWrapper;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapUserModelGenerator {
    public static LdapUserModel generate(String dn, Attributes attributes, boolean validate) throws NamingException, LdapManagerException {
        Log log = LogFactory.getLog(LdapUserModelGenerator.class);
        LdapUserModel response = new LdapUserModel();
        response.setFullname(dn);
        log.debug((Object)"Creating new user Model");
        NamingEnumeration<? extends Attribute> resultAttributes = attributes.getAll();
        while (resultAttributes.hasMore()) {
            String value;
            Attribute attribute = resultAttributes.next();
            String attributeId = attribute.getID();
            log.debug((Object)("Attribute id = " + attributeId));
            NamingEnumeration<?> values = attribute.getAll();
            if (attributeId.equals("objectClass")) {
                log.debug((Object)"Generating class object list");
                while (values.hasMore()) {
                    value = (String)values.next();
                    log.debug((Object)("Found value " + value));
                    response.addObjectClass(value);
                }
                continue;
            }
            if (attributeId.equals("userPassword")) {
                values.next();
                response.setEncryptedPasswordLabel();
                continue;
            }
            if (attributeId.equals("uid")) {
                response.setUserId(values.next().toString());
                continue;
            }
            log.debug((Object)"Updating attribute map...");
            if (!values.hasMore()) continue;
            value = values.next();
            log.debug((Object)("Found value " + value));
            if (value instanceof String) {
                response.addExtraAttribute(attributeId, value);
                continue;
            }
            log.warn((Object)("Not string value found in " + attributeId));
        }
        if (validate) {
            log.debug((Object)"Validate result...");
            if (!new LdapUserModelWrapper(response).validateData()) {
                throw new LdapManagerException("Received not valid data");
            }
        }
        log.debug((Object)"Model generated");
        return response;
    }
}

