/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.um.ldap.user.service;

import it.eng.rdlab.um.ldap.LdapDataModelWrapper;
import it.eng.rdlab.um.ldap.service.LdapGenericDataModelComparator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapUserDataModelComparator
extends LdapGenericDataModelComparator {
    private Log log = LogFactory.getLog(LdapGenericDataModelComparator.class);

    @Override
    public List<ModificationItem> compare(LdapDataModelWrapper dataModel1, LdapDataModelWrapper dataModel2) {
        ArrayList<ModificationItem> response = new ArrayList<ModificationItem>();
        this.log.debug((Object)"Generating single value attributes maps...");
        Map<String, String> singleValueAttributes1 = dataModel1.getAttributeMap();
        Map<String, String> singleValueAttributes2 = dataModel2.getAttributeMap();
        this.log.debug((Object)"Maps generated");
        this.log.debug((Object)"Loading password Parameters");
        String password1 = singleValueAttributes1.remove("userPassword");
        String password2 = singleValueAttributes2.remove("userPassword");
        this.log.debug((Object)"Password Parameters loaded");
        this.comparePasswordValue(response, password1, password2);
        this.compareSingleValueAttributes(response, singleValueAttributes1, singleValueAttributes2);
        this.log.debug((Object)"Generating multi value attributes maps...");
        Map<String, List<String>> multiValueAttributes1 = dataModel1.getListAttributeMap();
        Map<String, List<String>> multiValueAttributes2 = dataModel2.getListAttributeMap();
        this.log.debug((Object)"Maps generated");
        this.compareMultiValueAttributes(response, multiValueAttributes1, multiValueAttributes2);
        this.log.debug((Object)"Restoring password values");
        if (password1 != null) {
            singleValueAttributes1.put("userPassword", password1);
        }
        if (password2 != null) {
            singleValueAttributes2.put("userPassword", password1);
        }
        this.log.debug((Object)"Password values restored");
        return response;
    }

    public void comparePasswordValue(List<ModificationItem> response, String password1, String password2) {
        this.log.debug((Object)"Comparing password values");
        boolean password2Set = true;
        if (password2 == null || password2.equals("ENCRYPTED_PASSWORD")) {
            password2Set = false;
        }
        this.log.debug((Object)("New password set " + password2Set));
        if (password2Set) {
            boolean password1Set = true;
            if (password1 == null || password1.equals("ENCRYPTED_PASSWORD")) {
                password1Set = false;
            }
            this.log.debug((Object)("Old password data present " + password1Set));
            if (!password1Set || !password2.equals(password1)) {
                this.log.debug((Object)"User password changed");
                response.add(new ModificationItem(2, new BasicAttribute("userPassword", password2)));
            } else {
                this.log.debug((Object)"Old password equal to new password, the password won't be modified");
            }
        } else {
            this.log.debug((Object)"No password modification requested");
        }
    }
}

