/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.um.ldap.user.bean;

import it.eng.rdlab.um.ldap.LdapModelConstants;
import it.eng.rdlab.um.user.beans.UserModel;
import java.util.ArrayList;
import java.util.List;

public class LdapUserModel
extends UserModel
implements LdapModelConstants {
    public static final String OBJECT_CLASS_PERSON = "person";
    public static final String OBJECT_CLASS_INETORGPERSON = "inetOrgPerson";
    public static final String OBJECT_CLASS_ORGANIZATIONALPERSON = "organizationalPerson";
    public static final String COMMON_NAME = "cn";
    public static final String SURNAME = "sn";
    public static final String PASSWORD = "userPassword";
    public static final String UID = "uid";
    public static final String EMAIL = "mail";
    public static final String ENCRYPTED_PASSWORD_LABEL = "ENCRYPTED_PASSWORD";

    public LdapUserModel() {
        this.initObjects();
    }

    private void initObjects() {
        ArrayList<String> objectClasses = new ArrayList<String>();
        objectClasses.add("top");
        objectClasses.add(OBJECT_CLASS_PERSON);
        objectClasses.add(OBJECT_CLASS_INETORGPERSON);
        super.addObject("OBJECTCLASSES", objectClasses);
        this.setId("");
    }

    public LdapUserModel(String uuid, String dn, List<String> objectClasses) {
        super(uuid, dn);
        if (objectClasses == null) {
            objectClasses = new ArrayList<String>();
            objectClasses.add("top");
            objectClasses.add(OBJECT_CLASS_PERSON);
            objectClasses.add(OBJECT_CLASS_INETORGPERSON);
        } else {
            if (!objectClasses.contains("top")) {
                objectClasses.add("top");
            }
            if (!objectClasses.contains(OBJECT_CLASS_PERSON)) {
                objectClasses.add(OBJECT_CLASS_PERSON);
            }
            if (!objectClasses.contains(OBJECT_CLASS_INETORGPERSON)) {
                objectClasses.add(OBJECT_CLASS_INETORGPERSON);
            }
        }
        super.addObject("OBJECTCLASSES", objectClasses);
        if (dn == null) {
            this.setId("");
        }
        if (uuid == null) {
            this.setFullname("");
        }
    }

    public void setCN(String cn) {
        super.addObject(COMMON_NAME, (Object)cn);
    }

    public void setSN(String sn) {
        super.addObject(SURNAME, (Object)sn);
    }

    public String getCN() {
        return super.getStringObject(COMMON_NAME);
    }

    public String getSN() {
        return super.getStringObject(SURNAME);
    }

    public List<String> getObjectClasses() {
        return (List)super.getObject("OBJECTCLASSES");
    }

    public void addObjectClass(String objectClassName) {
        ((List)super.getObject("OBJECTCLASSES")).add(objectClassName);
    }

    public void setEncryptedPasswordLabel() {
        super.setPassword(ENCRYPTED_PASSWORD_LABEL.toCharArray());
    }

    public void addExtraAttribute(String name, String value) {
        super.addObject(name, (Object)value);
    }
}

