/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.um.ldap.group.service;

import it.eng.rdlab.um.beans.GenericModel;
import it.eng.rdlab.um.beans.GenericModelWrapper;
import it.eng.rdlab.um.exceptions.GroupRetrievalException;
import it.eng.rdlab.um.exceptions.UserManagementSystemException;
import it.eng.rdlab.um.group.beans.GroupModel;
import it.eng.rdlab.um.ldap.group.bean.LdapGroupModel;
import it.eng.rdlab.um.ldap.group.bean.LdapGroupModelWrapper;
import it.eng.rdlab.um.ldap.group.service.LdapCollectionManager;
import it.eng.rdlab.um.ldap.group.service.LdapGroupModelGenerator;
import it.eng.rdlab.um.ldap.service.exceptions.LdapManagerException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapGroupManager
extends LdapCollectionManager {
    private Log log = LogFactory.getLog(this.getClass());

    public LdapGroupManager(String baseDn) throws NamingException {
        super(baseDn);
    }

    public boolean createGroup(GroupModel groupModel) throws UserManagementSystemException {
        this.log.debug((Object)("Creating group with dn " + groupModel.getGroupId()));
        boolean response = false;
        try {
            response = this.ldapManager.createDataElement(new LdapGroupModelWrapper(groupModel));
        }
        catch (LdapManagerException e) {
            throw new UserManagementSystemException("unable to create the group", (Exception)e);
        }
        this.log.debug((Object)("Operation completed with response " + response));
        return response;
    }

    public GroupModel getGroup(String groupId) throws UserManagementSystemException, GroupRetrievalException {
        this.log.debug((Object)("Getting group with dn " + groupId));
        try {
            return (LdapGroupModel)this.generateGroup(groupId, new LdapGroupModelGenerator());
        }
        catch (LdapManagerException e) {
            this.log.error((Object)"Unable to contact the Ldap server", (Throwable)e);
            throw new GroupRetrievalException("Unable to contact the Ldap server", (Exception)e);
        }
        catch (Exception e) {
            this.log.error((Object)"Generic LDAP error", (Throwable)e);
            throw new UserManagementSystemException("Unable to contact the Ldap server", e);
        }
    }

    public boolean updateGroup(GroupModel groupModel) throws UserManagementSystemException, GroupRetrievalException {
        this.log.debug((Object)"Updating user");
        String groupDn = groupModel.getGroupId();
        GroupModel oldModel = this.getGroup(groupDn);
        if (oldModel == null) {
            this.log.error((Object)"No user found");
            return false;
        }
        this.log.debug((Object)"Performing update operation...");
        boolean response = false;
        try {
            response = this.ldapManager.updateData(new LdapGroupModelWrapper(oldModel), new LdapGroupModelWrapper(groupModel));
            this.log.debug((Object)("Operation completed with response " + response));
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)"Operation not completed", (Throwable)e);
            throw new UserManagementSystemException("Operation not completed", e);
        }
    }

    public List<GroupModel> listGroups() throws UserManagementSystemException, GroupRetrievalException {
        this.log.debug((Object)"Generic search");
        LdapGroupModel dummyFilter = new LdapGroupModel();
        dummyFilter.setGroupId(this.baseDn);
        return this.listGroups(dummyFilter);
    }

    public List<GroupModel> listGroups(GroupModel filter) throws UserManagementSystemException, GroupRetrievalException {
        this.log.debug((Object)"Filtered search");
        if (filter.getGroupId() == null || filter.getGroupId().length() == 0) {
            filter.setGroupId(this.baseDn);
        }
        return this.internalListGroups(new LdapGroupModelWrapper(filter), new LdapGroupModelGenerator());
    }

    public List<GroupModel> listSubGroupsByGroup(String groupId) throws UserManagementSystemException, GroupRetrievalException {
        this.log.debug((Object)("Listing subgroups for group " + groupId));
        GroupModel group = this.getGroup(groupId);
        if (group == null) {
            this.log.error((Object)"Main group not found");
            throw new GroupRetrievalException("Main group not found");
        }
        this.log.debug((Object)"Getting members...");
        GenericModelWrapper wrapper = new GenericModelWrapper((GenericModel)group);
        List members = (List)wrapper.getObjectParameter("member");
        ArrayList<GroupModel> response = new ArrayList<GroupModel>();
        if (members != null) {
            this.log.debug((Object)"Loading all groups");
            List<GroupModel> completeList = this.listGroups();
            for (GroupModel candidate : completeList) {
                this.log.debug((Object)("Checking if " + candidate.getGroupId() + " is a subgroup"));
                if (!members.contains(candidate.getGroupId())) continue;
                this.log.debug((Object)"Is a subgroup!");
                response.add(candidate);
            }
        }
        this.log.debug((Object)"List completed");
        return response;
    }

    public boolean createSubGroup(String parentGroupId, GroupModel groupModel) throws UserManagementSystemException, GroupRetrievalException {
        this.log.debug((Object)"Creating new Sub Group...");
        GroupModel parentModel = this.getGroup(parentGroupId);
        if (parentModel == null) {
            this.log.error((Object)"Parent group not found");
            throw new GroupRetrievalException("Parent group not found");
        }
        String subGroupDN = groupModel.getGroupId();
        this.log.debug((Object)("Sub group DN = " + subGroupDN));
        if (subGroupDN == null) {
            this.log.error((Object)"Subgroup DN not set");
            throw new GroupRetrievalException("Subgroup DN not set");
        }
        GroupModel subGroupModel = null;
        try {
            subGroupModel = this.getGroup(subGroupDN);
        }
        catch (Exception e) {
            this.log.error((Object)"An error occurred in finding the group");
        }
        if (subGroupModel == null && this.createGroup(groupModel)) {
            this.log.debug((Object)"Subgroup not found: created");
            subGroupModel = groupModel;
        } else if (subGroupModel == null) {
            this.log.error((Object)"Unable to create the sub group");
            return false;
        }
        this.log.debug((Object)"Updating sub group reference ");
        LdapGroupModel padGroupModel = new LdapGroupModel(parentModel);
        padGroupModel.addMemberDN(subGroupDN);
        boolean response = this.updateGroup(padGroupModel);
        this.log.debug((Object)("Operation completed with result " + response));
        return response;
    }
}

