/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.harvester.filesmanagement.archive;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.gcube.datatransformation.harvester.core.Message;
import org.gcube.datatransformation.harvester.core.MessageForEveryDataProvider;
import org.gcube.datatransformation.harvester.core.requestedtypes.verbs.ListRecords;
import org.gcube.datatransformation.harvester.filesmanagement.archive.RegisteredRequests;
import org.gcube.datatransformation.harvester.filesmanagement.manager.FilesManagerWrite;
import org.gcube.datatransformation.harvester.filesmanagement.times.CustomTimes;
import org.gcube.datatransformation.harvester.harvesting.FetchData;
import org.gcube.datatransformation.harvester.utils.GetProperties;

public class WriteUrls
implements FilesManagerWrite {
    private static final Logger logger = Logger.getLogger(WriteUrls.class);
    public final Object LOCK_WRITE = new Object();
    public static WriteUrls writeUrlsInstance = null;

    protected WriteUrls() {
    }

    public static WriteUrls getWriteUrlsInstance() {
        if (writeUrlsInstance == null) {
            writeUrlsInstance = new WriteUrls();
        }
        return writeUrlsInstance;
    }

    public void registerUriOnFile(MessageForEveryDataProvider messageForEveryDataProvider) {
        if (!messageForEveryDataProvider.getToDelete().booleanValue()) {
            RegisteredRequests.getRegisteredRequestsInstance().setInRequestsMapping(messageForEveryDataProvider.getInfoForHarvesting().getUrl(), messageForEveryDataProvider);
        } else {
            RegisteredRequests.getRegisteredRequestsInstance().removeFromRegisteredRequests(messageForEveryDataProvider.getInfoForHarvesting().getUrl(), messageForEveryDataProvider.getScope());
        }
    }

    public void registerUriOnFile(Map<String, String> parameters, String scope) {
        if (parameters.get("harvest-new-service") != null && parameters.get("harvest-new-service").equals("true")) {
            if (parameters.get("schema").equals("dc")) {
                Message message = new Message();
                message.setUrl(parameters.get("newUri"));
                message.setVerb(GetProperties.getPropertiesInstance().getDefaultVerb());
                String metadataPrefix = GetProperties.getPropertiesInstance().getDefaultMetadataPrefix();
                message.setListRecords(new ListRecords.ListRecordsBuilder(metadataPrefix).build());
                MessageForEveryDataProvider messageForEveryDataProvider = new MessageForEveryDataProvider();
                messageForEveryDataProvider.setInfoForHarvesting(message);
                messageForEveryDataProvider.setScope(scope);
                messageForEveryDataProvider.setSchemaSupportedForUrl("dc");
                if (parameters.get("defaultTime").equals("false")) {
                    String time = parameters.get("newIntervalTime");
                    TimeUnit timeUnit = null;
                    timeUnit = parameters.get("newTimeUnit").toUpperCase().equals("DAYS") ? TimeUnit.DAYS : (parameters.get("newTimeUnit").toUpperCase().equals("HOURS") ? TimeUnit.HOURS : (parameters.get("newTimeUnit").toUpperCase().equals("MINUTES") ? TimeUnit.MINUTES : TimeUnit.DAYS));
                    CustomTimes ct = new CustomTimes(parameters.get("newUri"), Integer.parseInt(time), timeUnit);
                    org.gcube.datatransformation.harvester.filesmanagement.times.WriteUrls.registerUriOnFile((CustomTimes)ct, (String)scope);
                }
                this.registerUriOnFile(messageForEveryDataProvider);
            } else {
                ArrayList locations = new ArrayList();
                List schemas = null;
                try {
                    schemas = FetchData.getSupportedSchemas((String)parameters.get("newUri"));
                    if (((String)schemas.get(0)).equals("locations")) {
                        locations.addAll(schemas);
                        locations.remove(0);
                        schemas = FetchData.getSupportedSchemas((String)((String)locations.get(0)));
                    }
                }
                catch (Exception e) {
                    logger.info((Object)e.getMessage());
                }
                if (parameters.get("defaultTime").equals("false")) {
                    String time = parameters.get("newIntervalTime");
                    TimeUnit timeUnit = null;
                    if (parameters.get("newTimeUnit").toUpperCase().equals("DAYS")) {
                        timeUnit = TimeUnit.DAYS;
                    } else if (parameters.get("newTimeUnit").toUpperCase().equals("HOURS")) {
                        timeUnit = TimeUnit.HOURS;
                    } else if (parameters.get("newTimeUnit").toUpperCase().equals("MINUTES")) {
                        timeUnit = TimeUnit.MINUTES;
                    }
                    CustomTimes ct = new CustomTimes(parameters.get("newUri"), Integer.parseInt(time), timeUnit);
                    org.gcube.datatransformation.harvester.filesmanagement.times.WriteUrls.registerUriOnFile((CustomTimes)ct, (String)scope);
                }
                if (schemas != null) {
                    ArrayList<MessageForEveryDataProvider> messages = RegisteredRequests.getRegisteredRequestsInstance().getFromRegisteredRequestsMapping(parameters.get("newUri"));
                    if (messages == null) {
                        messages = new ArrayList<MessageForEveryDataProvider>();
                    }
                    for (String schema : schemas) {
                        Message message = new Message();
                        message.setUrl(parameters.get("newUri"));
                        message.setVerb(GetProperties.getPropertiesInstance().getDefaultVerb());
                        message.setListRecords(new ListRecords.ListRecordsBuilder(schema).build());
                        MessageForEveryDataProvider messageForEveryDataProvider = new MessageForEveryDataProvider();
                        messageForEveryDataProvider.setInfoForHarvesting(message);
                        messageForEveryDataProvider.setScope(scope);
                        if (!locations.isEmpty()) {
                            messageForEveryDataProvider.setLocations(locations);
                        }
                        messages.add(messageForEveryDataProvider);
                    }
                    for (MessageForEveryDataProvider m : messages) {
                        m.setSchemaSupportedForUrl("all");
                        this.registerUriOnFile(m);
                    }
                }
            }
        } else {
            String metadataPrefix;
            Message message = new Message();
            message.setUrl(parameters.get("uri"));
            if (parameters.get("verb") == null) {
                message.setVerb(GetProperties.getPropertiesInstance().getDefaultVerb());
            }
            if ((metadataPrefix = parameters.get("metadataPrefix")) == null) {
                metadataPrefix = GetProperties.getPropertiesInstance().getDefaultMetadataPrefix();
            }
            if (parameters.get("set") != null) {
                message.setListRecords(new ListRecords.ListRecordsBuilder(metadataPrefix).set(parameters.get("set")).build());
            } else {
                message.setListRecords(new ListRecords.ListRecordsBuilder(metadataPrefix).build());
            }
            MessageForEveryDataProvider messageForEveryDataProvider = new MessageForEveryDataProvider();
            messageForEveryDataProvider.setInfoForHarvesting(message);
            messageForEveryDataProvider.setLastHarvestingTime(null);
            messageForEveryDataProvider.setStatus(null);
            messageForEveryDataProvider.setScope(scope);
            this.registerUriOnFile(messageForEveryDataProvider);
        }
    }

    public void writeToFile() {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            List messages = RegisteredRequests.getRegisteredRequestsInstance().getAllMessages();
            objectMapper.writeValue(new File(GetProperties.getPropertiesInstance().getArchivesFile()), (Object)messages);
        }
        catch (JsonGenerationException e) {
            logger.info((Object)e.getMessage());
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            logger.info((Object)e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.info((Object)e.getMessage());
            e.printStackTrace();
        }
    }
}

