<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/portlet_2_0" prefix="portlet"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://liferay.com/tld/theme" prefix="theme" %>

<theme:defineObjects/>
<portlet:defineObjects />

<div id="regional-data-collection-container" class="container-fluid">
	<div id="regional-data-collection-notification-container"></div>
	
	<div class="tabbable navbarTop hidden">
		<div class="row">  				
 			<ul class="nav nav-tabs">

   				<li class="regional-data-collection-data-collection active">
   					<a href="#tab2" data-toggle="tab">
   						<span class="title row">Data Collections</span>
   						<span class="description row">Manage data collections</span>
   					</a>
   				</li>

   				<li class="regional-data-collection-data-submission disabled">
   					<a href="#tab1" data-toggle="tab">
   						<span class="title row">Data Submissions</span>
   						<span class="description row">Manage data submissions</span>
   					</a>
   				</li>

   				<li class="regional-data-collection-data-model disabled">
   					<a href="#tab3" data-toggle="tab">
   						<span class="title row">Data Models</span>
   						<span class="description row">Manage data models</span>
   					</a>
   				</li>

   				<li class="regional-data-collection-app-users disabled">
   					<a href="#tab4" data-toggle="tab">
   						<span class="title row">Users</span>
   						<span class="description row">Manage users</span>
   					</a>
   				</li>
 			</ul>	
		</div>

		<div class="tab-content">
			<div class="tab-pane" id="tab1">
	
				<div id="regional-data-collection-data-submissions-container">
					
				</div>
			</div>

			<div class="tab-pane active" id="tab2">
				<div id="regional-data-collection-data-collections-container">
				
				</div>
			</div>
			
			<div class="tab-pane" id="tab3">
				<div id="regional-data-collection-data-models-container">
				
				</div>
				
				<div id="regional-data-collection-data-models-details-container" class="hidden">
				
				</div>
			</div>
			
			<div class="tab-pane" id="tab4">
				<div id="regional-data-collection-app-users-container">
				
				</div>
			</div>

		</div>
		
		<div>
			<div class="widget-container"></div>
			<div class="modal-container"></div>
		</div>
		
	</div>
</div>

<p id="regional-data-collection-portlet-info" data-namespace="<portlet:namespace/>" data-loginurl="<portlet:resourceURL />"></p>

<portlet:actionURL name="dataModel" var="dataModel">
<portlet:param name="action" value="dataModelSubmit"></portlet:param>
</portlet:actionURL>

<link rel="stylesheet" type="text/css" href="<c:url value="/css/main.css" />" />
<link rel="stylesheet" type="text/css" href="<c:url value="/css/util-classes.css" />" />
<link rel="stylesheet" type="text/css" href="<c:url value="/css/datatables/jquery.dataTables.min.css" />" />
<link rel="stylesheet" type="text/css" href="<c:url value="/css/datatables/dataTables.bootstrap.css" />" />
<link rel="stylesheet" type="text/css" href="<c:url value="/css/navbar_top.css" />" />
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.5.0/css/font-awesome.min.css">
<link rel="stylesheet" type="text/css" href="<c:url value="/css/spinner.css" />" />
<link rel="stylesheet" type="text/css" href="<c:url value="/modules/datatable/datatable-widget.css"/>" />
<link rel="stylesheet" type="text/css" href="<c:url value="/css/datatables/buttons.dataTables.min.css"/>" />
<link rel="stylesheet" type="text/css" href="<c:url value="/js/lou-multi-select-e052211/css/multi-select.css"/>" />
<link rel="stylesheet" type="text/css" href="<c:url value="/js/chosen_v1.8.2/chosen.min.css"/>" />

<script src="<c:url value="/js/jquery-1.12.0.min.js"/>"></script>
<script src="<c:url value="/js/jquery-ui-1.10.3.min.js"/>"></script>
<script src="<c:url value="/js/jquery.validate.min.js"/>"></script>
<script src="<c:url value="/js/jquery.validate.additional-methods.min.js"/>"></script>
<script src="<c:url value="/js/bootstrap-2.3.2.min.js"/>"></script>
<script src="<c:url value="/js/lou-multi-select-e052211/js/jquery.multi-select.js" />" ></script>
<script src="<c:url value="/js/chosen_v1.8.2/chosen.jquery.js" />" ></script>
<script src="<c:url value="/js/common/notificator.js"/>"></script>
<script src="<c:url value="/js/common/ajax.js"/>"></script>
<script src="<c:url value="/js/dataTables/jquery.dataTables.min.js" />"></script>
<script src="<c:url value="/js/dataTables/dataTables.tableTools.min.js" />" ></script>
<script src="<c:url value="/js/dataTables/dataTables.responsive.min.js" />" ></script>
<script src="<c:url value="/js/dataTables/dataTables.select.min.js" />"></script>
<script src="<c:url value="/js/dataTables/dataTables.buttons.min.js" />"></script>
<script src="<c:url value="/modules/datatable/datatable-widget.js" />"></script>
<script src="<c:url value="/modules/config/config.js"/>"></script>
<script src="<c:url value="/modules/data-submission/data-submission.js" />" ></script>
<script src="<c:url value="/modules/data-collection/data-collection.js" />" ></script>
<script src="<c:url value="/modules/data-model/data-model.js" />" ></script>
<script src="<c:url value="/modules/data-model/data-model-details.js" />" ></script>
<script src="<c:url value="/modules/app-user/app-user.js" />" ></script>

<script type="text/javascript">
	(function() {
		$(document).ready(function () {
		    window.DEBUGWIDGETS = false;

			var renderURL = '<portlet:renderURL><portlet:param name="jspPage" value="{url}.jsp" /><portlet:param name="getParams" value="{params}" /></portlet:renderURL>';
			var resourceURL = '<portlet:resourceURL id="{url}?{parameters}" />';
			var resourceURLNoParams = '<portlet:resourceURL id="{url}" />';
			var contextPath = '<%=request.getContextPath()%>/';
			var nameSpace = $('#regional-data-collection-portlet-info').data('namespace');
			
			window.config.init({
			    appNotificator : $('#regional-data-collection-notification-container'),
			    appSpinner : $('#regional-data-collection-container'),
				contextPath : contextPath,
				locale : '<%=renderRequest.getAttribute("userLocale")%>',
				modalContainer : $('.modal-container'),
				nameSpace : nameSpace,
				resourceURL : resourceURL,
				resourceURLNoParams : resourceURLNoParams,
				renderURL : renderURL,
				username : '<%=renderRequest.getAttribute("username")%>',
				widgetContainer : $('.widget-container')
			});
		});
	})();
</script>