$.widget("rdc.TabmanEditor", $.rdb.BaseWidget, {
    options : {
        ajaxCalls : null,
        callback : null,
        config : null,
        dataSubmission : null,
        defaultCallback : null,
        formElementsIdClassNames : {
            agency : 'regional-data-collection-tabman-export-agency',
            description : 'regional-data-collection-tabman-export-description',
            formId : 'regional-data-collection-tabman-exort-form',
            rights : 'regional-data-collection-tabman-export-rights',
            validFromDatePickerId : 'regional-data-collection-tabman-export-date-valid-from',
            validUntilToDatePickerId : 'regional-data-collection-tabman-export-date-valid-until-to',
        },
        formValidation : null,
        isSubmission : null,
        setButtonVisibility : null,
        url : null,
        validator : null
    },

    _create : function() {
        var self = this;
        if( typeof DEBUGWIDGETS !== 'undefined' && DEBUGWIDGETS === true )
            console.log('TabmanEditor');
        this.options.url = 'modules/data-submission/tabman-editor/tabman-editor.jsp';
        this.options.callback = function() {
            self.initUIBindings();
            self.initValidation();
        };

        this._super();
    },

    agencyInput : null,

    descriptionInput : null,

	find : function(selector) {
		return this.element.find(selector);
	},

	getData : function() {
	    var self = this;
	    let $form = this.find('#' + this.options.formElementsIdClassNames.formId);

	    var data = {};
	    data.id = this.options.dataSubmission.dataCollectionsDropdown.val();
        data.agency = this.agencyInput.val();
        data.validFrom = new Date( self.validFromDatePicker.val() ).getTime();
        if( isNaN( data.validFrom ) ) data.validFrom = null;
        data.validUntiTo = new Date( self.validUntilToDatePicker.val() ).getTime();
        if( isNaN( data.validUntiTo ) ) data.validUntiTo = null;
        data.description = this.descriptionInput.val();
        data.rights = this.rightsInput.val();

        return data;
	},

    initUIBindings : function() {
        let startDate = dataSubmission.getDataCollectionStartDate();
        let endDate = dataSubmission.getDataCollectionEndDate();
        this.agencyInput = this.find( '#' + this.options.formElementsIdClassNames.agency );
        this.descriptionInput = this.find( '#' + this.options.formElementsIdClassNames.description );
        this.rightsInput = this.find( '#' + this.options.formElementsIdClassNames.rights );
        this.validFromDatePicker = this.find('#' + this.options.formElementsIdClassNames.validFromDatePickerId);
        this.validUntilToDatePicker = this.find('#' + this.options.formElementsIdClassNames.validUntilToDatePickerId);

        this.validFromDatePicker.val(this.options.config.dateIn_yyy_MM_dd_format(startDate));
        this.validUntilToDatePicker.val(this.options.config.dateIn_yyy_MM_dd_format(endDate));
    },

    initValidation : function() {
        var self = this;

        jQuery.validator.addMethod("fromToDateLesserThanToDateInTabmanExportModal", function(value, element) {
            var dateFromStr = $(element).val();
            var dateToStr = self.validUntilToDatePicker.val();
            if(dateToStr.length === 0) return true;
            else if( dateFromStr.length === 0 && dateToStr.length !== 0 ) return false;
            else return new Date(dateFromStr) < new Date(dateToStr);
        }, "Must be lesser than the Valid Until date");

        jQuery.validator.addMethod("toDateLesserThanFromDateInTabmanExportModal", function(value, element) {
            var dateToStr = $(element).val();
            var dateFromStr = self.validFromDatePicker.val();
            if( dateToStr.length === 0 ) return true;
            else if( dateFromStr.length === 0 && dateToStr.length !== 0 ) return false;
            else return new Date(dateFromStr) < new Date(dateToStr);
        }, "Must be greater than the Valid From");

        this.options.validator = this.find('#' + this.options.formElementsIdClassNames.formId).validate({
            onkeyup: function (element, event) {
                if (event.which === 9 && this.elementValue(element) === "") {
                    return;
                } else {
                    this.element(element);
                }

                if(self.options.setButtonVisibility !== null)
                    self.options.setButtonVisibility('save-button', self.isValid());
            },
            onfocusout : function (element, event) {
                if (event.which === 9 && this.elementValue(element) === "") {
                    return;
                } else {
                    this.element(element);
                }

                if(self.options.setButtonVisibility !== null)
                    self.options.setButtonVisibility('save-button', self.isValid());
            },
            rules : {
                'regional-data-collection-tabman-export-agency' : {
                    required : true
                },

                'regional-data-collection-tabman-export-date-valid-from' : {
                    date : true,
                    fromToDateLesserThanToDateInTabmanExportModal : true
                },

                'regional-data-collection-tabman-export-date-valid-until-to' : {
                    date : true,
                    toDateLesserThanFromDateInTabmanExportModal : true
                }
            },
            highlight : function(element) {
                $(element).closest('.control-group').addClass('error');
            },
            success : function(label, element) {
                $(element).closest('.control-group').removeClass('error');
                label.remove();
            },
            errorPlacement : function(error, element) {
                error.css('color', 'red');
                error.appendTo( element.closest('.controls') );
            }
        });

        let $form = this.element.find('#' + self.options.formElementsIdClassNames.formId);

        $form.find('input[type=date]').on('change', function() {
            $form.find('input[type=date]').each(function(index, value) {
                $(this).closest("form").validate().element(this);
            });

            var valid = $(this).closest("form").validate().checkForm();
            if(self.options.setButtonVisibility !== null)
                self.options.setButtonVisibility('save-button', valid);
        });
    },

	isValid : function() {
		return this.options.validator.checkForm();
	},

	rightsInput : null,

	submitForm : function() {
	    var self = this;
	    let formData = {};
	    if( self.options.isSubmission ) {
            formData.id = self.options.dataSubmission.dataTable.getSelectedRowData().id;
	    } else {
	        formData.id = self.options.dataSubmission.collectionId;
	    }

	    formData.isSubmission = self.options.isSubmission;
	    formData.data = JSON.stringify( self.getData() );

        var self = this;

        var bSC = function() {
            self.options.dataSubmission.clearMessage();
            if(self.tabmanLoader === null) {
                self.tabmanLoader = self.options.config.getPageSpinner();
                self.tabmanLoader.insertBefore(self.options.dataSubmission.dataSubmissionContainer);
            } else self.tabmanLoader.show();
        };

        var oSC = function(data) {
            self.options.dataSubmission.showMessage(data.result,"success");
        };

        var oEC = function(jqXHR, textStatus, errorThrown) {
            self.options.dataSubmission.errorHandling(jqXHR, errorThrown);
        };

        var oCC = function() {
            self.tabmanLoader.remove();
        };

        self.options.ajaxCalls.post('importDataCollectionToTabMan', formData, bSC, oSC, oEC, oCC);
	},

	tabmanLoader : null,

    validFromDatePicker : null,

    validUntilToDatePicker : null
});