 $.widget("rdc.ViewCdtEditor", $.rdb.BaseWidget, {
	options : {
		ajaxCalls : null,
		callback : null,
		config : null,
		dataSubmission : null,
		entityType : null,
		exportedToTabmanContainerClass : 'tabman-export-info',
		exportedToTabmanLabelClass : 'is-exported-to-tabman',
		exportedToTabmanTextNegative : 'NO',
		exportedToTabmanTextPositive : 'YES',
		formElementsIdClassNames : {
		    cdtDataTableId : 'regional-data-collection-cdt-datatable',
		    dataSubmissionMetadataDataTableId : 'regional-data-collection-data-submission-metadata-datatable',
		    dataTableLabel : 'table-label',
		    metaDataDataTableLabel : 'metadata',
		},
		portletDataTableWidgetLoadHeadersCallback : null,
		portletDataTableWidgetName : null,
		portletDataTableWidgetOptions : null,
		setButtonVisibility : null,
		url : null
	},
	
	_create : function() {
		let $spinner =  this.options.config.getLoadContentSpinner();
		$spinner.insertBefore(this.element);
		var self = this;
	    if( typeof DEBUGWIDGETS !== 'undefined' && DEBUGWIDGETS === true )
            console.log('ViewCdtEditor');
		this.options.url = 'modules/data-submission/cdt-editor/cdt-editor.jsp';
		
		this.options.callback = function() {
			self.initUIBindings();
			$spinner.remove();
		};
		this._super();
	},
	
	_destroy : function() {
		this.element.html('');
	},

	_elementForAttributeDisplay : function( tagName, textContent ) {
	    let self = this;
	    let $row = $('<div></div>', {
	        class : 'row-fluid'
	    });

	    let $spanTag = $('<span></span>', { text : tagName } );
	    let $colon = $('<span></span>', { text : ' : ' } );
	    let $spanText = $( '<span></span>', {
	        text : textContent,
	        css : {
	            color : '#0271be',
                'font-weight' : 'bold'
	        }
	    });

	    $row.append( $spanTag ).append( $colon ).append( $spanText );

	    return $row;
	},

	_getElementForAttributeDisplay : function( tagName, textContent ) {
	    return this._elementForAttributeDisplay( tagName, textContent ).clone();
	},

	cdtDataTable : null,

	dataSubmissionMetadataDataTable : null,
	
	initUIBindings : function() {
	    var self = this;
		this.cdtDataTable = this.element.find( '#' + this.options.formElementsIdClassNames.cdtDataTableId );
		this.dataSubmissionMetadataDataTable = this.element.find( '#' + this.options.formElementsIdClassNames.dataSubmissionMetadataDataTableId );
		this.cdtToolbar = this.element.find('portlet-datatable-toolbar');

		let displayTabmanExportedInfoCallback = function( message, attributes ) {
//show message if data collection
            let $tabmanInfo = self.element.find( '.' + self.options.exportedToTabmanContainerClass );
            let $container = $tabmanInfo.parent();
		    if ( self.options.entityType === self.options.dataSubmission.options.entityType.DATACOLLECTION ) {

		        self.element.find( '.' + self.options.exportedToTabmanLabelClass ).text( message );
		        $tabmanInfo.removeClass('hidden');

		    } else if( self.options.entityType === self.options.dataSubmission.options.entityType.DATASUBMISSION && attributes !== null && !$.isEmptyObject(attributes) && attributes.metadata && !$.isEmptyObject( attributes.metadata ) ) {
                let $metaDataLabel = self.element.find( '.' + self.options.formElementsIdClassNames.dataTableLabel + '.' + self.options.formElementsIdClassNames.metaDataDataTableLabel );
                $metaDataLabel.removeClass('hidden');

                let metaData = Object.assign( {}, attributes.metadata );

                let headers = [];
                let modifiedEntries = {};

                Object.entries(metaData).map( x => {
                    if( x[0].toLowerCase().indexOf('date') > -1 ) {
                        x[1] = self.options.config.formatDate( x[1] );
                    }

                    let charPosition = 0;
                    let str = '';
                    for( let i=0; i < x[0].length; i++ ) {
                        if( x[0].charAt(i) === x[0].charAt(i).toUpperCase() ) {
                            const index = x[0].indexOf( x[0].charAt(i) );
                            str += x[0].slice( charPosition, index ) + " ";
                            charPosition = index;
                        }
                    }
                    if( str.length > 0 ) {
                        x[0] = str + x[0].slice( charPosition, x[0].length );
                        modifiedEntries[ x[0] ] = x[1];
                        Object.assign(metaData, modifiedEntries);
                    }
                    headers.push( x[0] );
                });

                var columnDefs = [];
                $.each( headers, function(index,value) {
                    columnDefs.push({
                        title : value,
                        fieldName : value,
                        targets : index
                    });
                });

                let $dataSubmissionMetadataDataTable = self.dataSubmissionMetadataDataTable.PortletDataTable({
                    checkBox : false,
                    columnDefs : columnDefs,
                    data : [],
                    order : [[0, "asc"]]
                });

                $dataSubmissionMetadataDataTable.data("dt-PortletDataTable").showProcessing();

                setTimeout( function() {
                    $dataSubmissionMetadataDataTable.DataTable().rows.add( new Array( metaData ) );

                    //workaround to show paging buttons
                    $dataSubmissionMetadataDataTable.DataTable().draw();

                    $dataSubmissionMetadataDataTable.data("dt-PortletDataTable").hideProcessing();

                }, 250 );

                //workaround to show paging buttons
                self.dataSubmissionMetadataDataTable.DataTable().draw();

            } else return;
		};this.options.formElementsIdClassNames.dataTablesWrapper;

		this.options.portletDataWidgetLoadHeadersCallback(this.cdtDataTable, displayTabmanExportedInfoCallback);
	}
});