$.widget('rdb.StaticColumnsDropdown', $.rdb.BaseWidget, {
	options : {
		ajaxCalls : null,
		callback : null,
		config : null,
		dataModelDetails : null,
		formElementsIdClassName : {
		    chosenContainerClassName : 'chosen-container',
			staticColumnsMultiselectDropdown : 'regional-data-collection-static-fields-dropdown',
			staticColumnsNotificator : 'regional-data-collection-data-model-details-static-fields-notificator'
		},
		notificator : null,
		url : null
	},

	_create : function() {
		var self = this;
		if( typeof DEBUGWIDGETS !== 'undefined' && DEBUGWIDGETS === true )
		    console.log('StaticColumnsDropdown');

		this.options.url = 'modules/data-model/static-fields-selector/static-fields-selector-template.jsp';
		this.options.callback = function() {
			self.initUIBindings();
			self.initValidation();
		};

		this._super();
	},

	_destroy : function() {
		this.element.html('');
	},

	_getSaveButton : function() {
	    var self = this;
	    this.saveButtonLoaded = true;

        let saveButton = $('<button></button>', {
            text : 'Apply',
            class : 'save-button',
            css : {
                background: '#eeeeee',
                'border-radius' : '.5em',
                color: '#0271be',
                'margin-left' : '1em',
                 padding: '.3em 1.5em',
                 opacity : '0.5',
                 cursor : 'auto'
            },
            disabled : true
        }).click(function(event) {
            event.preventDefault();

            let url = 'updateDataModel';

            let postData = {};
            let data = {};
            data.fields = [];
            postData.id = self.options.dataModelDetails.getdataModelID();

            $.each( self.dropDown.find('option:selected'), function(i,v) {
                data.fields.push($(this).text());
            });

            postData.jsonData = JSON.stringify({
                properties : {
                    staticFields : data.fields
                },
                updateUser : {
                   label : self.options.config.username
                }
            });

            var bSC = function() { self.clearMessage(); self.staticColumnsLoader.show(); };
            var oSC = function() {
                self.showMessage("Static columns were stored successfully",'success');
            };
            var oEC = function(text, type) {
                self.showMessage(text, type);
            };

            var oCC = function() { self.staticColumnsLoader.hide(); };

            self.options.ajaxCalls.post(url, postData, bSC, oSC, oEC, oCC);
        });

        return saveButton;
	},

	clear : function() {
	    this.dropDown.html('');
	},

	clearMessage : function() {
        this.options.notificator.clearMessage(this.notificator);
    },

    dropDown : null,

    errorHandling : function(jqXHR, exception) {
        this.options.notificator.errorHandling(this.notificator, jqXHR, exception);
    },

	fillDimensionAttributesDropdown : function() {
		var self = this;
        self.clear();
        self.update();

		var url = 'getColumnsOfDataModel';

		var data = {};
		data["id"] = this.options.dataModelDetails.getdataModelID();

		var bSC = function(){
            self.clearMessage();

			if(self.staticColumnsLoader === null) {
				self.staticColumnsLoader = self.options.config.getInlineSpinner();
				self.staticColumnsLoader.insertAfter( self.find( '.' + self.options.formElementsIdClassName.chosenContainerClassName ) );
			} else self.staticColumnsLoader.show();
		};

		var oSC = function(data) {

			var data = $.parseJSON(data.result);
			var columns = data.tableTemplate.columnMapper.columns;
			columns.sort();

//			datatype multi select dropdown
//			self.find('.'+self.options.formElementsIdClassName.staticColumnsMultiselectDropdown).html('');

			$.each(columns, function(i,v){

				$('<option></option>',{
					text : v.label,
					value : v.id
				}).appendTo(self.dropDown);
			});

			self.update();

            if(!self.saveButtonLoaded)
			    self.saveButton = self._getSaveButton().insertAfter( self.find( '.' + self.options.formElementsIdClassName.chosenContainerClassName ) );

			let dmData = self.options.dataModelDetails.getDataModelData();
            if( typeof dmData.properties !== 'undefined' ) {
                let staticFields = dmData.properties.staticFields;

                let options = self.dropDown.find('option');
                $.each(options, function(index, value) {
                    if(staticFields.indexOf( $(this).text() ) > -1 ) {
                        $(this).attr('selected', true);
                    }
                });

                self.update();
            }

            self.saveButtonOpacity(self.dropDown);
		};

		var oEC = function(jqXHR, textStatus, errorThrown) {
			self.options.dataModelDetails.showMessage(jqXHR.responseText, "error");
		};

		var oCC = function(){
			self.staticColumnsLoader.hide();
		};

		this.options.ajaxCalls.post(url, data, bSC, oSC, oEC, oCC);
	},

	fillFormWithValues : function() {
		let data = this.options.dataModelDetails.dataTable.getSelectedRowData();
		let $dropDown = this.find(this.options.formElementsIdClassName.dimensionAttributeMultiselectDropdown);
		let values = [];
		$.each($dropDown.find('option'), function() {
			values.push($(this).val());
		});

		var fieldVals = [];
		data.fields.map(function(obj) {
			fieldVals.push(obj.fieldId);
		});
		$dropDown.multiSelect('select', fieldVals);

	},

	find : function(selector) {
		return this.element.find(selector);
	},

	getData : function() {
		var data = {};

		data.fields = [];
		var $dropdownOptions = this.find(this.options.formElementsIdClassName.dimensionAttributeMultiselectDropdown +' option:selected');
		$.each($dropdownOptions, function(index, value) {
			data.fields.push({
					fieldId : $(this).val(),
					fieldName : $(this).text()
			});
		});

		return data;
	},

	initUIBindings : function() {
	    var self = this;
        this.notificator = this.find('.' + this.options.formElementsIdClassName.staticColumnsNotificator);
        this.dropDown = self.find('.'+self.options.formElementsIdClassName.staticColumnsMultiselectDropdown);

        if( self.options.dataModelDetails.activeDataCollectionperiod === false ) {
            this.dropDown.on('change', function() {
               self.saveButtonOpacity(self.dropDown);
            });
        } else {
            self.saveButton[0].disabled = true;
            self.saveButton.css('opacity' , '0.5');
            self.saveButton.css('cursor', 'auto');
        }

        this.dropDown.chosen({width: '50%'});
        this.fillDimensionAttributesDropdown();
	},

	initValidation : function() {

	},

	notificator : null,

	reload : function() {
	    this.fillDimensionAttributesDropdown();
	},

	saveButton : null,

	saveButtonLoaded : false,

	saveButtonOpacity : function($dropdown) {
	    var self = this;
	    let container = self.find( '.' + self.options.formElementsIdClassName.chosenContainerClassName );

	    if( this.options.dataModelDetails.getDataModelData().activeDataCollectionPeriod === true ) {
	        container.css('pointer-events', 'none');
	        this.saveButton[0].disabled = true;
            this.saveButton.css('opacity' , '0.5');
            this.saveButton.css('cursor', 'auto');

	        return;
	    }
        if( $dropdown.find('option:selected').length > 0 ) {
            this.saveButton[0].disabled = false;
            this.saveButton.css('opacity' , '1.0');
            this.saveButton.css('cursor', 'pointer');
        } else {
            this.saveButton[0].disabled = true;
            this.saveButton.css('opacity' , '0.5');
            this.saveButton.css('cursor', 'auto');
        }
        container.css('pointer-events', 'auto');
	},

	showMessage : function(text, type) {
        this.options.notificator.setText(this.notificator, text, type);
    },

	staticColumnsLoader : null,

	update : function() {
	    this.dropDown.trigger("chosen:updated");
	},
});