$.widget('rdb.ImportDataModelEditor', $.rdb.BaseWidget, {
	options : {
		ajaxCalls : null,
		callback : null,
		config : null,
		dataModel : null,
		setButtonVisibility : null,
		url : null
	},
	
	_create : function() {
		var self = this;
		if( typeof DEBUGWIDGETS !== 'undefined' && DEBUGWIDGETS === true )
		    console.log('ImportDataModelEditor');
		this.options.url = 'modules/data-model/import-data-model-editor/import-data-model-editor.jsp';
		this.options.callback = function() {
			self.initUIBindings();
			self.initValidation();
		};
		
		this._super();
	},
	
	_destroy : function() {
		this.element.html('');
	},
	
	initialText : null,
	
	initUIBindings : function() {
		var self = this;
		
		this.initialText = self.element.find('#regional-data-collection-data-model-import-form-file-name').text();
		
		this.element.find('#regional-data-collection-data-model-import-form-file').off().on('change', function() {
			var filename = $(this).val().replace(/C:\\fakepath\\/i, '');

			if(filename === '') {
				filename = self.initialText;
			}
//			$('#regional-data-collection-data-model-import-form-file-name').val(filename);
			
			self.element.find('#regional-data-collection-data-model-import-form-file-name').text(filename);
//			$('#regional-data-collection-data-model-import-form-file-name').focus();
			
			self.validator.element(self.element.find('#regional-data-collection-data-model-import-form-file'));
		});
	},
	
	initValidation : function() {
		var self = this;
		
		this.validator = this.element.find('#regional-data-collection-data-model-import-form').validate({
	        onkeyup: function (element, event) {
	            if (event.which === 9 && this.elementValue(element) === "") {
	                return;
	            } else {
	                this.element(element);
	            }
	        },
	        onfocusout : function (element, event) {
	            if (event.which === 9 && this.elementValue(element) === "") {
	                return;
	            } else {
	                this.element(element);
	            }
	        },
			rules : {
				'regional-data-collection-data-model-import-form-name' : {
					required : true
				},
				
				'regional-data-collection-data-model-import-form-version' : {
					required : true
				},
				
				'regional-data-collection-data-model-import-form-file' : {
					required : true,
				    extension : 'xml'
				},
				
				'regional-data-collection-data-model-import-form-uri' : {
					required : true
				},
			},
		    highlight : function(element) {
		    	$(element).closest('.control-group').addClass('error');
		    },
		    success : function(label, element) {
			    $(element).closest('.control-group').removeClass('error');
			    label.remove();
		    },
		    errorPlacement : function(error, element) {
		    	error.css('color', 'red');
		    	error.appendTo( element.closest('.controls') );
		    }
		});
		
		//Enable disable form-submit button 
		this.element.find('#regional-data-collection-data-model-import-form input')
		.bind('input', function() {
			var valid = $(this).closest("form").validate().checkForm();
			if(self.options.setButtonVisibility !== null)
				self.options.setButtonVisibility('save-button', valid);
		});
		
		this.element.find('#regional-data-collection-data-model-import-form-file').on('change', function() {
			var valid = $(this).closest("form").validate().checkForm();
			if(self.options.setButtonVisibility !== null)
				self.options.setButtonVisibility('save-button', valid);
		});
	},
	
	validator : null
});