$.widget('rdb.EditMandatoryConstraintEditor', $.rdb.BaseWidget, {
	options : {
		ajaxcalls : null,
		callback : null,
		config : null,
		constraintsLoaderContainerClassName : 'regional-data-collection-data-model-edit-constaints-columns-loader-container',
		constraintType : null,
		formElementsIdClassNames : {
			dimensionAttributeDropdown : '#regional-data-collection-data-model-constaints-edit-dimension-attribute'
		},
		myConstraintType : 'attributeMandatory',
		url : null,
		dataModelDetails : null,
		setButtonVisibility : null,
		selectedRowConstraintType : null,
	},
	
	_create : function() {
		var self = this;
		if( typeof DEBUGWIDGETS !== 'undefined' && DEBUGWIDGETS === true )
		    console.log('MandatoryConstraintEditor');
		this.options.url = 'modules/data-model/edit-data-model-details-editors/edit-data-model-details-sub-editors/edit-mandatory-constraint-editor/edit-mandatory-constraint-editor.jsp';
		this.options.callback = function() {
			self.initUIBindings();
			self.initValidation();

			if( self.options.dataModelDetails.activeDataCollectionperiod ) {
                self.turnFormElementsReadonly();
            }
		};
		
		this._super();
	},
	
	_destroy : function() {
		this.element.html('');
	},
	
	constraintsLoader : null,
	
	fillDimensionAttributesDropdown : function() {
		var self = this;
		var url = 'getColumnsOfDataModel';

		var data = {};
		data["id"] = this.options.dataModelDetails.getdataModelID();

		var bSC = function(){
			if(self.constraintsLoader === null) {
				self.constraintsLoader = self.options.config.getInlineSpinner();
				self.constraintsLoader.appendTo( self.find( '.' + self.options.constraintsLoaderContainerClassName ) );
			} else self.constraintsLoader.show();
		};

		var oSC = function(data) {

			var data = $.parseJSON(data.result);
			var columns = data.tableTemplate.columnMapper.columns;
			columns.sort();

//			attribute single select dropdown
			self.find(self.options.formElementsIdClassNames.dimensionAttributeDropdown).html('');

			$.each(columns, function(i,v){
				$('<option></option>',{
					text : v.label,
					value : v.id
				}).appendTo(self.find(self.options.formElementsIdClassNames.dimensionAttributeDropdown));
			});

			if(self.options.selectedRowConstraintType === self.options.myConstraintType)
				self.fillFormWithValues();
            self.options.setButtonVisibility( 'save-button', self.isValid() );
		};

		var oEC = function(jqXHR, textStatus, errorThrown) {
			self.options.dataModel.showMessage(jqXHR.responseText, "error");
		};

		var oCC = function(){
			self.constraintsLoader.hide();
		};

		window.ajaxCalls.post(url, data, bSC, oSC, oEC, oCC);
	},
	
	fillFormWithValues : function () {
		var self = this;
		
		let data = this.options.dataModelDetails.dataTable.getSelectedRowData();
		let $dropDown = this.find(this.options.formElementsIdClassNames.dimensionAttributeDropdown);
		let values = [];
		$.each($dropDown.find('option'), function() {
			values.push($(this).val());
		});
		
		if(values.indexOf(data.fieldId))
			$dropDown.val(data.fieldId);
	},
	
	find : function(selector) {
		return this.element.find(selector);
	},
	
	getData : function() {
		var data = {};
		
		data.fieldId = this.find(this.options.formElementsIdClassNames.dimensionAttributeDropdown+ ' option:selected').val().trim();
		data.field = this.find(this.options.formElementsIdClassNames.dimensionAttributeDropdown + ' option:selected').text().trim();
		
		return data;
	},
	
	initUIBindings : function() {
		var self = this;
		
		setTimeout(function() {
			self.fillDimensionAttributesDropdown();
		}, 300);
	},
	
	initValidation : function() {
		
	},

    isValid : function() {
        return this.options.validator.checkForm();
    }
});