$.widget('rdc.EditIntegerRangeConstraintEditor', $.rdb.BaseWidget, {
	options : {
		ajaxCalls : null,
		callback : null,
		config : null,
		dataModelDetails : null,
		decimal : null,
		fieldId : null,
		formElementsIdClassNames : {
			min : '#regional-data-collection-data-model-constaints-edit-min-integer-decimal-value',
			max : '#regional-data-collection-data-model-constaints-edit-max-integer-decimal-value',
		},
		integer : null,
		myRangeTypes : ['integer', 'decimal'],
		rangeType : null,
		setButtonVisibility : null,
		url : null
	},
	
	_create : function() {
	    if( typeof DEBUGWIDGETS !== 'undefined' && DEBUGWIDGETS === true )
	        console.log('EditIntegerRangeConstraintEditor');
		var self = this;
		
		this.options.url = 'modules/data-model/edit-data-model-details-editors/edit-data-model-details-sub-editors/datatype-range-constraint-editor/datatype-range-constraint-subeditors/datatype-range-constraint-integer-editor/datatype-range-constraint-integer-editor.jsp';
		this.options.callback = function() {
			self.initUIBindings();
			self.initValidation();
			if(self.options.myRangeTypes.indexOf(self.options.rangeType) > -1) {
				self.fillFormWithValues();
			}
            self.options.setButtonVisibility( 'save-button', self.isValid() );

			if( self.options.dataModelDetails.activeDataCollectionperiod ) {
                self.turnFormElementsReadonly();
            }
		};
		
		this._super();
	},
	
	_destroy : function() {
	    this.find('[name="' + this.options.formElementsIdClassNames.min.substring(1) + '"]').rules('remove');
        this.find('[name="' + this.options.formElementsIdClassNames.max.substring(1) + '"]').rules('remove');
		this.element.html('');
	},
	
	fillFormWithValues : function() {
		let data = this.options.dataModelDetails.dataTable.getSelectedRowData();
		if( this.options.fieldId !== this.options.dataModelDetails.dataTable.getSelectedRowData().fieldId ) return;
		this.find(this.options.formElementsIdClassNames.min).val(data.min);
		this.find(this.options.formElementsIdClassNames.max).val(data.max);
	},
	
	find : function(selector) {
		return this.element.find(selector);
	},
	
	getData : function() {
		var data = {};
		
		data.min = this.find(this.options.formElementsIdClassNames.min).val();
		data.max = this.find(this.options.formElementsIdClassNames.max).val();
		
		return data;
	},
	
	initUIBindings : function() {
		
	},
	
	initValidation : function() {
	    var self = this;

        jQuery.validator.addMethod("minIntLesserThanMaxIntInEditConstraintForm", function(value, element) {
            var minValue = $(element).val();
            var maxValue = self.find('[name="' + self.options.formElementsIdClassNames.max.substring(1) + '"]').val();
            if( minValue.length === 0 && maxValue.length === 0 ) return true;
            else if( minValue.length !== 0 && maxValue.length === 0 || minValue.length === 0 && maxValue.length !== 0 ) return false;
            else return Number(minValue) < Number(maxValue);
        }, "Must be lesser than the Max Value");

        jQuery.validator.addMethod("maxIntLesserThanMinIntInEditConstraintForm", function(value, element) {
            var maxValue = $(element).val();
            var minValue = self.find('[name="' + self.options.formElementsIdClassNames.min.substring(1) + '"]').val();
            if( minValue.length === 0 && maxValue.length === 0 ) return true;
            else if( minValue.length !== 0 && maxValue.length === 0 || minValue.length === 0 && maxValue.length !== 0 ) return false;
            else return Number(minValue) < new Number(maxValue);
        }, "Must be greater than the Min Value");

        jQuery.validator.addMethod("integerValue", function(value, element) {
            var maxValue = $(element).val();
            if(maxValue.length > 0 && maxValue.charAt( maxValue.length - 1) === '.' ) return false;
            var num = Number( maxValue );

            if( isNaN( num ) ) {
                return false;
            } else {
                return num === parseInt( num, 10 );
            }
        }, "Please enter only integers");

        if( self.options.integer === true ) {
            this.find('[name="' + this.options.formElementsIdClassNames.min.substring(1) + '"]').rules('add', {
                integerValue : true,
                minIntLesserThanMaxIntInEditConstraintForm : true
            });

            this.find('[name="' + this.options.formElementsIdClassNames.max.substring(1) + '"]').rules('add', {
                integerValue : true,
                maxIntLesserThanMinIntInEditConstraintForm : true
            });
        } else if ( self.options.decimal === true ) {
            this.find('[name="' + this.options.formElementsIdClassNames.min.substring(1) + '"]').rules('add', {
                number : true,
                minIntLesserThanMaxIntInEditConstraintForm : true
            });

            this.find('[name="' + this.options.formElementsIdClassNames.max.substring(1) + '"]').rules('add', {
                number : true,
                maxIntLesserThanMinIntInEditConstraintForm : true
            });
        }

        this.find(this.options.formElementsIdClassNames.min).keyup(function() {
            self.options.validator.element(self.options.formElementsIdClassNames.max);
        });

        this.find(this.options.formElementsIdClassNames.max).keyup(function() {
            self.options.validator.element(self.options.formElementsIdClassNames.min);
        });
	},

    isValid : function() {
        return this.options.validator.checkForm();
    }
	
});