$.widget('rdc.EditDateRangeConstraintEditor', $.rdb.BaseWidget, {
	options : {
		ajaxCalls : null,
		callback : null,
		config : null,
		dataModelDetails : null,
		fieldId : null,
		formElementsIdClassNames : {
			min : '#regional-data-collection-data-model-constaints-edit-min-date-value',
			max : '#regional-data-collection-data-model-constaints-edit-max-date-value',
		},
		myRangeTypes : ['date'],
		rangeType : null,
		setButtonVisibility : null,
		url : null,
		validator : null
	},
	
	_create : function() {
	    if( typeof DEBUGWIDGETS !== 'undefined' && DEBUGWIDGETS === true )
	        console.log('DateRangeConstraintEditor');
		var self = this;
		
		this.options.url = 'modules/data-model/edit-data-model-details-editors/edit-data-model-details-sub-editors/datatype-range-constraint-editor/datatype-range-constraint-subeditors/datatype-range-constraint-date-editor/datatype-range-constraint-date-editor.jsp';
		this.options.callback = function() {
			self.initUIBindings();
			self.initValidation();
			if(self.options.myRangeTypes.indexOf(self.options.rangeType) > -1) {
				self.fillFormWithValues();
			}
            self.options.setButtonVisibility( 'save-button', self.isValid() );

			if( self.options.dataModelDetails.activeDataCollectionperiod ) {
                self.turnFormElementsReadonly();
            }
		};
		
		this._super();
	},
	
	_destroy : function() {
	    this.find('[name="' + this.options.formElementsIdClassNames.min.substring(1) + '"]').rules('remove');
	    this.find('[name="' + this.options.formElementsIdClassNames.max.substring(1) + '"]').rules('remove');
		this.element.html('');
	},
	
	fillFormWithValues : function() {
		let data = this.options.dataModelDetails.dataTable.getSelectedRowData();
        if( this.options.fieldId !== this.options.dataModelDetails.dataTable.getSelectedRowData().fieldId ) return;
		this.find(this.options.formElementsIdClassNames.min).val(this.options.config.dateIn_yyy_MM_dd_format(Number(data.min)));
		this.find(this.options.formElementsIdClassNames.max).val(this.options.config.dateIn_yyy_MM_dd_format(Number(data.max)));
	},
	
	find : function(selector) {
		return this.element.find(selector);
	},
	
	getData : function() {
		var data = {};
		
		data.min = new Date(this.find(this.options.formElementsIdClassNames.min).val()).getTime();
		data.max = new Date(this.find(this.options.formElementsIdClassNames.max).val()).getTime();
		
		return data;
	},
	
	initUIBindings : function() {
		
	},
	
	initValidation : function() {
        var self = this;

        jQuery.validator.addMethod("minDateLesserThanMaxDateInEditConstraintForm", function(value, element) {
            var minDate = $(element).val();
            var maxDate = self.find('[name="' + self.options.formElementsIdClassNames.max.substring(1) + '"]').val();
            if(maxDate.length === 0) return true;
            else return new Date(minDate) < new Date(maxDate);
        }, "Must be lesser than the Max Value");

        jQuery.validator.addMethod("maxDateLesserThanMinDateInEditConstraintForm", function(value, element) {
            var maxDate = $(element).val();
            var minDate = self.find('[name="' + self.options.formElementsIdClassNames.min.substring(1) + '"]').val();
            if(minDate.length === 0) return true;
            else return new Date(minDate) < new Date(maxDate);
        }, "Must be greater than the Min Value");

        this.find('[name="' + this.options.formElementsIdClassNames.min.substring(1) + '"]').rules('add', {
            date : true,
            minDateLesserThanMaxDateInEditConstraintForm : true
        });

        this.find('[name="' + this.options.formElementsIdClassNames.max.substring(1) + '"]').rules('add', {
            date : true,
            maxDateLesserThanMinDateInEditConstraintForm : true
        });

        this.find(this.options.formElementsIdClassNames.min).on('change focus', function() {
            self.options.validator.element($(this));
            self.options.validator.element(self.options.formElementsIdClassNames.max);
            if(self.options.setButtonVisibility !== null) {
                self.options.setButtonVisibility('save-button', self.isValid());
            }
        });

        this.find(this.options.formElementsIdClassNames.max).on('change focus', function() {
            self.options.validator.element($(this));
            self.options.validator.element(self.options.formElementsIdClassNames.min);
            if(self.options.setButtonVisibility !== null) {
                self.options.setButtonVisibility('save-button', self.isValid());
            }
        });

        self.options.setButtonVisibility( 'save-button', self.isValid() );
	},

	isValid : function() {
	    return this.options.validator.checkForm();
	}
});