$.widget('rdb.DataTypeRangeConstraintEditor', $.rdb.BaseWidget, {
	options : {
		ajaxCalls : null,
		callback : null,
		config : null,
		dimensionAttributeLoadeContainer : 'regional-data-collection-data-model-constaints-columns-loader-container',
		dataModelDetails : null,
		setButtonVisibility : null,
		url : null,
		validator : null
	},
	
	_create : function() {
		var self = this;
		if( typeof DEBUGWIDGETS !== 'undefined' && DEBUGWIDGETS === true )
		    console.log("DataTypeRangeConstraintEditor");
		this.options.url = 'modules/data-model/add-data-model-details-editors/add-data-model-details-sub-editors/datatype-range-constraint-editor/datatype-range-constraint-editor.jsp';
		this.options.callback = function() {
			self.initUIBindings();
			self.initValidation();
			self.initDefaultRangeDataType();
		};
		
		this._super();
	},
	
	_destroy : function() {
		this.element.html('');
	},
	
	dimensionAttributeLoader : null,
	
	fillDimensionAttributesDropdown : function() {
		var self = this;
		var url = 'getColumnsOfDataModel';

		var data = {};
		data["id"] = this.options.dataModelDetails.getdataModelID();

		var bSC = function(){
			if(self.dimensionAttributeLoader === null) {
				self.dimensionAttributeLoader = self.options.config.getInlineSpinner();
				self.dimensionAttributeLoader.appendTo( self.element.find( '.' + self.options.dimensionAttributeLoadeContainer ) );
			} else self.dimensionAttributeLoader.show();
		};

		var oSC = function(data) {

			var data = $.parseJSON(data.result);
			var columns = data.tableTemplate.columnMapper.columns;
			columns.sort();

//			attribute single select dropdown
			self.element.find('#regional-data-collection-data-model-constaints-add-dimension-attribute').html('');

			$.each(columns, function(i,v){
				$('<option></option>',{
					text : v.label,
					value : v.id
				}).appendTo(self.element.find('#regional-data-collection-data-model-constaints-add-dimension-attribute'));
			});
			
		};

		var oEC = function(jqXHR, textStatus, errorThrown) {
			self.options.dataModel.showMessage(jqXHR.responseText, "error");
		};

		var oCC = function(){
			self.dimensionAttributeLoader.hide();
		};

		window.ajaxCalls.post(url, data, bSC, oSC, oEC, oCC);
	},
	
	getData : function() {
		var self = this;
		var data = {};
		
		data.datatype = this.element.find('#regional-data-collection-data-model-constaints-add-range-constraint-datatype').val();
		data.fieldId = this.element.find('#regional-data-collection-data-model-constaints-add-dimension-attribute option:selected').val().trim();
		data.field = this.element.find('#regional-data-collection-data-model-constaints-add-dimension-attribute option:selected').text().trim();
		
		var datatype = this.element.find('#regional-data-collection-data-model-constaints-add-range-constraint-datatype').val();
		var minMaxValues = {};
		
		switch(datatype) {
		
		case dataModelDetails.constants.INTEGER :
//			data.min = this.element.find('#regional-data-collection-data-model-constaints-add-min-integer-decimal-value').val();
//			data.max = this.element.find('#regional-data-collection-data-model-constaints-add-max-integer-decimal-value').val();
			
//			break;
		case dataModelDetails.constants.DECIMAL :
//			data.min = this.element.find('#regional-data-collection-data-model-constaints-add-min-integer-decimal-value').val();
//			data.max = this.element.find('#regional-data-collection-data-model-constaints-add-max-integer-decimal-value').val();
			minMaxValues = self.element.find('.' + self.rangeDataTypesConainerClass).IntegerRangeConstraintEditor('getData');
			
			break;
		case dataModelDetails.constants.DATE :
//			data.min = new Date(this.element.find('#regional-data-collection-data-model-constaints-add-min-date-value').val()).getTime();
//			data.max = new Date(this.element.find('#regional-data-collection-data-model-constaints-add-max-date-value').val()).getTime();
			minMaxValues = self.element.find('.' + self.rangeDataTypesConainerClass).DateRangeConstraintEditor('getData');
			
			break;
		default :
			alert("Not known datatype selected");
		
		};
		
		for(var property in minMaxValues) {
			data[property] = minMaxValues[property];
		}
		
		return data;
	},
	
	initDefaultRangeDataType : function() {
	    this.options.integer = true;
	    this.options.decimal = null;
		this.element.find('.' + this.rangeDataTypesConainerClass).IntegerRangeConstraintEditor(this.options);
	},
	
	initUIBindings : function() {
		var self = this;
		
		setTimeout(function() {
			self.fillDimensionAttributesDropdown();
		}, 300);
		
		this.element.find('#regional-data-collection-data-model-constaints-add-range-constraint-datatype').off().on('change', function() {
//		    if( typeof DEBUGWIDGETS !== 'undefined' && DEBUGWIDGETS === true )
//			    console.log("i");
//			Destroy the widgets initialized on this element
			$.each(self.element.find('.' + self.rangeDataTypesConainerClass).data(), function(i, v) {
				if( typeof self.element.find('.' + self.rangeDataTypesConainerClass).data(i).destroy !== 'undefined' )
					typeof self.element.find('.' + self.rangeDataTypesConainerClass).data(i).destroy();
			});
			
			var dataType = $(this).val();
			
			switch(dataType) {
			
			case dataModelDetails.constants.INTEGER :
			    self.options.integer = true;
			    self.options.decimal = null;
			    self.element.find('.' + self.rangeDataTypesConainerClass).IntegerRangeConstraintEditor(self.options);

            	break;

			case dataModelDetails.constants.DECIMAL :
			    self.options.integer = null;
			    self.options.decimal = true;
				self.element.find('.' + self.rangeDataTypesConainerClass).IntegerRangeConstraintEditor(self.options);
				
				break;
			case dataModelDetails.constants.DATE :
			    self.options.integer = null;
                self.options.decimal = null;
				self.element.find('.' + self.rangeDataTypesConainerClass).DateRangeConstraintEditor(self.options);
				
				break;
			default :
				alert("Not known datatype option");
			}
		});
	},
	
	initValidation : function() {
		
	},
	
	rangeDataTypesConainerClass : 'add-range-constraint-datatypes-container'
});