$.widget('rdb.DataCollectionAddModal', $.rdb.BaseWidget, {
	options : {
		ajaxCalls : null,
		callback : null,
		config : null,
		dataCollection : null,
		url : null,
		schemaVersionLoaderContainer : 'regional-data-collection-data-collection-add-form-schema-version-loader-container',
		setButtonVisibility : null
	},
	
	_create : function() {
	    if( typeof DEBUGWIDGETS !== 'undefined' && DEBUGWIDGETS === true )
		    console.log('DataCollectionAddModal');
		var self = this;
		this.options.url = 'modules/data-collection/data-collection-add-datacollection-editor-widget/data-collection-add-datacollection-editor-widget.jsp';
		this.options.callback = function() {
			self.initUIbindings();
			self.initValidation();
		};
		
		this._super();
	},
	
	_destroy : function() {
		this.element.html('');
	},
	
	initUIbindings : function() {
		var self = this;
		
		var bSC = function() {
			if(self.schemaVersionLoader === null) {
				self.schemaVersionLoader = config.getInlineSpinner();
				self.schemaVersionLoader.appendTo(self.element.find('.'+self.options.schemaVersionLoaderContainer));
			} else self.schemaVersionLoader.show();
		};
		
		var oSC = function(data) {
			var dataModels = $.parseJSON($.parseJSON(data).result);
			
			$.each(dataModels, function(i,v) {
				$('<option></option>', {
					text : v.label + ' - ' + v.version,
					value : v.id
				})
				.appendTo($('#regional-data-collection-data-collection-add-form-schema-version'));
			});
		};
		
		var oEC = function(jqXHR, textStatus, errorThrown) {
			$('#regional-data-collection-data-collection-add-modal').modal('hide');
			self.options.dataCollection.errorHandling(jqXHR, errorThrown);
		};
		
		var oCC = function() {
			self.options.dataCollection.clearMessage();
			self.schemaVersionLoader.hide();
		};
		
		self.options.ajaxCalls.get('getAllDataModels', bSC, oSC, oEC, oCC);
	}, 
	
	initValidation : function() {
		var self = this;
		
		jQuery.validator.addMethod("fromToDateLesserThanToDateInAddDataCollectionForm", function(value, element) {
			var dateFromStr = $(element).val();
			var dateToStr = $('#regional-data-collection-data-collection-add-form-open-to-date').val();
			if(dateToStr.length === 0) return true;
			else return new Date(dateFromStr) < new Date(dateToStr);
		}, "Must be lesser than the Open to date");
		
		jQuery.validator.addMethod("toDateLesserThanFromDateInAddDataCollectionForm", function(value, element) {
			var dateToStr = $(element).val();
			var dateFromStr = $('#regional-data-collection-data-collection-add-form-open-from-date').val();
			if(dateFromStr.length === 0) return true;
			else return new Date(dateFromStr) < new Date(dateToStr);
		}, "Must be greater than the Open from date");

		this.validator = this.element.find('#regional-data-collection-data-model-add-form').validate({
	        onkeyup: function (element, event) {
	            if (event.which === 9 && this.elementValue(element) === "") {
	                return;
	            } else {
	                this.element(element);
	            }
	            
	            var valid = $(event.target).closest("form").validate().checkForm();
	            if(self.options.setButtonVisibility !== null)
					self.options.setButtonVisibility('save-button', valid);
	        },
	        onfocusout : function (element, event) {
	            if (event.which === 9 && this.elementValue(element) === "") {
	                return;
	            } else {
	                this.element(element);
	            }
	        },
			rules : {
				'regional-data-collection-data-collection-add-form-label' : {
					required : true
				},
				
				'regional-data-collection-data-collection-add-form-open-from-date' : {
					required : true,
					date : true,
					fromToDateLesserThanToDateInAddDataCollectionForm : true
				},
				
				'regional-data-collection-data-collection-add-form-open-to-date' : {
					required : true,
					date : true,
					toDateLesserThanFromDateInAddDataCollectionForm : true
				},

				'regional-data-collection-data-collection-add-form-schema-version' : {
				    required : true
				}
			},
		    highlight : function(element) {
		    	$(element).closest('.control-group').addClass('error');
		    },
		    success : function(label, element) {
			    $(element).closest('.control-group').removeClass('error');
			    label.remove();
		    },
		    errorPlacement : function(error, element) {
		    	error.css('color', 'red');
		    	error.appendTo( element.closest('.controls') );
		    }
		});
		
		this.element.find('#regional-data-collection-data-collection-add-form-open-from-date').on('change', function() {
			self.validator.element($(this));
		});
		
		this.element.find('#regional-data-collection-data-collection-add-form-open-to-date').on('change', function() {
			self.validator.element($(this));
		});
		
		this.element.find('#regional-data-collection-data-model-add-form input[type=date]')
		.on('change', function() {
			self.element.find('#regional-data-collection-data-model-add-form input[type=date]').each(function(index, value) {
				if($(this).val() !== '')
					$(this).closest("form").validate().element(this);
			});
			
			var valid = $(this).closest("form").validate().checkForm();
			if(self.options.setButtonVisibility !== null)
				self.options.setButtonVisibility('save-button', valid);
		});

		this.element.find('#regional-data-collection-data-collection-add-form-schema-version').on('change', function() {
		    var valid = $(this).closest("form").validate().checkForm();
            if(self.options.setButtonVisibility !== null)
                self.options.setButtonVisibility('save-button', valid);
		});
	},
	
	schemaVersionLoader : null,
	
	validator : null
});