/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.regional.data.collection.portlet;

import com.google.gson.Gson;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.util.PortalUtil;
import gr.cite.regional.data.collection.portlet.BaseController;
import gr.cite.regional.data.collection.portlet.models.DataModelImport;
import gr.cite.regional.data.collection.portlet.models.DataModelStorage;
import gr.cite.regional.data.collection.portlet.models.Domain;
import gr.cite.regional.data.collection.portlet.models.UserReference;
import gr.cite.regional.data.collection.portlet.utils.Utils;
import gr.cite.regional.data.collection.portlet.web.HttpUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.ws.rs.core.Response;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
public class DataModelController
extends BaseController {
    private static Log _log = LogFactoryUtil.getLog(DataModelController.class);

    @ResourceMapping(value="getAllDataModels")
    public void getAllDataModels(ResourceRequest request, ResourceResponse response) throws IOException {
        _log.debug((Object)"Getting all data models");
        String serviceUrl = "dataModels";
        HashMap headers = new HashMap();
        Response clientResponse = this.singletonHttpClient.doGet(serviceUrl, headers);
        int status = clientResponse.getStatus();
        _log.debug((Object)("Server responded with status: " + status));
        JSONObject stateObject = JSONFactoryUtil.createJSONObject();
        String result = (String)clientResponse.readEntity(String.class);
        stateObject.put("result", result);
        if (status == HttpStatus.OK.value()) {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)status, (Object)stateObject);
        } else if (status == HttpStatus.INTERNAL_SERVER_ERROR.value()) {
            HttpUtils.returnResponseAsJson((ResourceResponse)response, (Integer)HttpStatus.INTERNAL_SERVER_ERROR.value(), (Object)result);
        }
    }

    @ResourceMapping(value="importDSD")
    public void importDSD(ResourceRequest request, ResourceResponse response, PortletRequest portletRequest) throws IOException {
        _log.debug((Object)"Importing a data model");
        UploadPortletRequest uploadRequest = PortalUtil.getUploadPortletRequest((PortletRequest)portletRequest);
        String uploadFileName = uploadRequest.getFileName("dataModelXMLFile");
        File uploadFile = uploadRequest.getFile("dataModelXMLFile");
        _log.debug((Object)("Uploaded a file with name: " + uploadFileName + " and size: " + uploadFile.length()));
        FileInputStream styleInputStream = new FileInputStream(uploadFile);
        String fileImportContent = Utils.getStringFromXmlFile((InputStream)styleInputStream);
        String paramJson = uploadRequest.getParameter("dataModelImport");
        DataModelImport dataModelImport = (DataModelImport)new Gson().fromJson(paramJson, DataModelImport.class);
        JSONObject stateObject = JSONFactoryUtil.createJSONObject();
        stateObject.put("name", dataModelImport.getName());
        stateObject.put("version", dataModelImport.getVersion());
        stateObject.put("uri", dataModelImport.getUri());
        Domain domain = new Domain();
        domain.setLabel(scope);
        UserReference user = new UserReference(username);
        String serviceUrl = "dataModels";
        HashMap headers = new HashMap();
        DataModelStorage dm = new DataModelStorage();
        dm.setDefinition(fileImportContent);
        dm.setDomain(domain);
        dm.setLabel(dataModelImport.getName());
        dm.setURI(dataModelImport.getUri());
        dm.setVersion(dataModelImport.getVersion());
        dm.setCreateUser(user);
        Response clientResponse = this.singletonHttpClient.doPost(serviceUrl, headers, (Object)dm);
        int status = clientResponse.getStatus();
        _log.debug((Object)("Server responded with status: " + status));
        String result = (String)clientResponse.readEntity(String.class);
        stateObject.put("result", result);
        if (status == HttpStatus.OK.value()) {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)status, (Object)stateObject);
        } else if (status == HttpStatus.INTERNAL_SERVER_ERROR.value()) {
            HttpUtils.returnResponseAsJson((ResourceResponse)response, (Integer)HttpStatus.INTERNAL_SERVER_ERROR.value(), (Object)result);
        }
    }

    @ResourceMapping(value="deleteDataModel")
    public void deleteDataModel(ResourceRequest request, ResourceResponse response) throws IOException {
        _log.debug((Object)"Deleting a data model");
        int id = ParamUtil.getInteger((PortletRequest)request, (String)"id");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String serviceUrl = "dataModels/" + id;
        Response clientResponse = this.singletonHttpClient.doDelete(serviceUrl, headers);
        int status = clientResponse.getStatus();
        _log.debug((Object)("Server responded with status: " + status));
        String result = (String)clientResponse.readEntity(String.class);
        JSONObject stateObject = JSONFactoryUtil.createJSONObject();
        stateObject.put("result", result);
        if (status == HttpStatus.NO_CONTENT.value()) {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)HttpStatus.NO_CONTENT.value(), (Object)stateObject);
        } else if (status == HttpStatus.NOT_FOUND.value()) {
            HttpUtils.returnResponseAsJson((ResourceResponse)response, (Integer)HttpStatus.NOT_FOUND.value(), (Object)result);
        } else if (status == HttpStatus.INTERNAL_SERVER_ERROR.value()) {
            HttpUtils.returnResponseAsJson((ResourceResponse)response, (Integer)HttpStatus.INTERNAL_SERVER_ERROR.value(), (Object)result);
        }
    }

    @ResourceMapping(value="getColumnsOfDataModel")
    public void getColumnsOfDataModel(ResourceRequest request, ResourceResponse response) {
        _log.debug((Object)"Getting columns of a data model");
        int id = ParamUtil.getInteger((PortletRequest)request, (String)"id");
        HashMap headers = new HashMap();
        String serviceUrl = "dataModels/" + id + "/definition";
        Response clientResponse = this.singletonHttpClient.doGet(serviceUrl, headers);
        int status = clientResponse.getStatus();
        _log.debug((Object)("Server responded with status: " + status));
        String result = (String)clientResponse.readEntity(String.class);
        JSONObject stateObject = JSONFactoryUtil.createJSONObject();
        stateObject.put("result", result);
        if (status == HttpStatus.OK.value()) {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)HttpStatus.OK.value(), (Object)stateObject);
        } else if (status == HttpStatus.INTERNAL_SERVER_ERROR.value()) {
            HttpUtils.returnResponseAsJson((ResourceResponse)response, (Integer)HttpStatus.INTERNAL_SERVER_ERROR.value(), (Object)result);
        }
    }

    @ResourceMapping(value="addNewConstraint")
    public void addNewConstraint(ResourceRequest request, ResourceResponse response) throws IOException {
        _log.debug((Object)"Adding new constraint");
        Integer id = ParamUtil.getInteger((PortletRequest)request, (String)"dataModelId");
        String json = ParamUtil.getString((PortletRequest)request, (String)"jsonData");
        String serviceUrl = "dataModels/" + id + "/constraints";
        HashMap headers = new HashMap();
        Response clientResponse = this.singletonHttpClient.doPost(serviceUrl, headers, (Object)json);
        int status = clientResponse.getStatus();
        _log.debug((Object)("Server responded with status: " + status));
        String result = (String)clientResponse.readEntity(String.class);
        JSONObject stateObject = JSONFactoryUtil.createJSONObject();
        stateObject.put("result", result);
        if (status == HttpStatus.OK.value() || status == HttpStatus.CREATED.value()) {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)status, (Object)stateObject);
        } else if (status == HttpStatus.INTERNAL_SERVER_ERROR.value()) {
            HttpUtils.returnResponseAsJson((ResourceResponse)response, (Integer)HttpStatus.INTERNAL_SERVER_ERROR.value(), (Object)result);
        }
    }

    @ResourceMapping(value="getConstraintsByDataModelId")
    public void getConstraintsByDataModelId(ResourceRequest request, ResourceResponse response) {
        _log.debug((Object)"Get constraints");
        String id = ParamUtil.getString((PortletRequest)request, (String)"id");
        String serviceUrl = "dataModels/" + id + "/constraints";
        HashMap headers = new HashMap();
        Response clientResponse = this.singletonHttpClient.doGet(serviceUrl, headers);
        int status = clientResponse.getStatus();
        _log.debug((Object)("Server responded with status: " + status));
        String result = (String)clientResponse.readEntity(String.class);
        JSONObject stateObject = JSONFactoryUtil.createJSONObject();
        stateObject.put("result", result);
        if (status == HttpStatus.OK.value()) {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)status, (Object)stateObject);
        } else if (status == HttpStatus.INTERNAL_SERVER_ERROR.value()) {
            HttpUtils.returnResponseAsJson((ResourceResponse)response, (Integer)HttpStatus.INTERNAL_SERVER_ERROR.value(), (Object)result);
        }
    }

    @ResourceMapping(value="deleteConstraint")
    public void deleteConstraint(ResourceRequest request, ResourceResponse response) {
        _log.debug((Object)"Delete constraint");
        String dataModelId = ParamUtil.getString((PortletRequest)request, (String)"dataModelId");
        String constraintId = ParamUtil.getString((PortletRequest)request, (String)"constraintId");
        String serviceUrl = "dataModels/" + dataModelId + "/constraints/" + constraintId;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        Response clientResponse = this.singletonHttpClient.doDelete(serviceUrl, headers);
        int status = clientResponse.getStatus();
        _log.debug((Object)("Server responded with status: " + status));
        String result = (String)clientResponse.readEntity(String.class);
        JSONObject stateObject = JSONFactoryUtil.createJSONObject();
        stateObject.put("result", result);
        if (status == HttpStatus.NO_CONTENT.value()) {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)HttpStatus.NO_CONTENT.value(), (Object)stateObject);
        } else if (status == HttpStatus.NOT_FOUND.value()) {
            HttpUtils.returnResponseAsJson((ResourceResponse)response, (Integer)HttpStatus.NOT_FOUND.value(), (Object)result);
        } else if (status == HttpStatus.INTERNAL_SERVER_ERROR.value()) {
            HttpUtils.returnResponseAsJson((ResourceResponse)response, (Integer)HttpStatus.INTERNAL_SERVER_ERROR.value(), (Object)result);
        }
    }

    @ResourceMapping(value="editConstraints")
    public void editConstraint(ResourceRequest request, ResourceResponse response) {
        _log.debug((Object)"Editing an existing constraint");
        Integer dataModelId = ParamUtil.getInteger((PortletRequest)request, (String)"dataModelId");
        Integer constraintId = ParamUtil.getInteger((PortletRequest)request, (String)"constraintId");
        String json = ParamUtil.getString((PortletRequest)request, (String)"jsonData");
        String serviceUrl = "dataModels/" + dataModelId + "/constraints/" + constraintId;
        HashMap headers = new HashMap();
        Response clientResponse = this.singletonHttpClient.doPost(serviceUrl, headers, (Object)json);
        int status = clientResponse.getStatus();
        _log.debug((Object)("Server responded with status: " + status));
        String result = (String)clientResponse.readEntity(String.class);
        JSONObject stateObject = JSONFactoryUtil.createJSONObject();
        stateObject.put("result", result);
        if (status == HttpStatus.OK.value()) {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)status, (Object)stateObject);
        } else if (status == HttpStatus.NOT_FOUND.value()) {
            HttpUtils.returnResponseAsJson((ResourceResponse)response, (Integer)HttpStatus.NOT_FOUND.value(), (Object)result);
        } else if (status == HttpStatus.INTERNAL_SERVER_ERROR.value()) {
            HttpUtils.returnResponseAsJson((ResourceResponse)response, (Integer)HttpStatus.INTERNAL_SERVER_ERROR.value(), (Object)result);
        }
    }

    @ResourceMapping(value="getCodelistFieldsForDataModel")
    public void getCodelistForDataModel(ResourceRequest request, ResourceResponse response) {
        _log.debug((Object)"Getting codelist of data model");
        Integer id = ParamUtil.getInteger((PortletRequest)request, (String)"id");
        String fieldId = ParamUtil.getString((PortletRequest)request, (String)"fieldId");
        String serviceUrl = "dataModels/" + id + "/definition/" + fieldId;
        HashMap headers = new HashMap();
        Response clientResponse = this.singletonHttpClient.doGet(serviceUrl, headers);
        int status = clientResponse.getStatus();
        _log.debug((Object)("Server responded with status: " + status));
        String result = (String)clientResponse.readEntity(String.class);
        JSONObject stateObject = JSONFactoryUtil.createJSONObject();
        stateObject.put("result", result);
        if (status == HttpStatus.OK.value()) {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)status, (Object)stateObject);
        } else if (status == HttpStatus.NOT_FOUND.value()) {
            HttpUtils.returnResponseAsJson((ResourceResponse)response, (Integer)HttpStatus.NOT_FOUND.value(), (Object)result);
        } else if (status == HttpStatus.INTERNAL_SERVER_ERROR.value()) {
            HttpUtils.returnResponseAsJson((ResourceResponse)response, (Integer)HttpStatus.INTERNAL_SERVER_ERROR.value(), (Object)result);
        }
    }

    @ResourceMapping(value="updateDataModel")
    public void updateDataModel(ResourceRequest request, ResourceResponse response) {
        _log.debug((Object)"Getting codelist of data model");
        Integer id = ParamUtil.getInteger((PortletRequest)request, (String)"id");
        String jsonData = ParamUtil.getString((PortletRequest)request, (String)"jsonData");
        String serviceUrl = "dataModels/" + id;
        HashMap headers = new HashMap();
        Response clientResponse = this.singletonHttpClient.doPost(serviceUrl, headers, (Object)jsonData);
        int status = clientResponse.getStatus();
        _log.debug((Object)("Server responded with status: " + status));
        String result = (String)clientResponse.readEntity(String.class);
        JSONObject stateObject = JSONFactoryUtil.createJSONObject();
        stateObject.put("result", result);
        if (status == HttpStatus.OK.value()) {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)status, (Object)stateObject);
        } else if (status == HttpStatus.NOT_FOUND.value()) {
            HttpUtils.returnResponseAsJson((ResourceResponse)response, (Integer)HttpStatus.NOT_FOUND.value(), (Object)result);
        } else if (status == HttpStatus.INTERNAL_SERVER_ERROR.value()) {
            HttpUtils.returnResponseAsJson((ResourceResponse)response, (Integer)HttpStatus.INTERNAL_SERVER_ERROR.value(), (Object)result);
        }
    }
}

