/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.gcube.io.jsonwebtoken.impl.io.FilteredOutputStream;
import org.gcube.io.jsonwebtoken.io.Encoder;
import org.gcube.io.jsonwebtoken.io.EncodingException;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.lang.Strings;

public class ByteBase64UrlStreamEncoder
implements Encoder<OutputStream, OutputStream> {
    private final Encoder<byte[], String> delegate;

    public ByteBase64UrlStreamEncoder(Encoder<byte[], String> delegate) {
        this.delegate = (Encoder)Assert.notNull(delegate, (String)"delegate cannot be null.");
    }

    public OutputStream encode(OutputStream outputStream) throws EncodingException {
        Assert.notNull((Object)outputStream, (String)"outputStream cannot be null.");
        return new TranslatingOutputStream(outputStream, this.delegate);
    }

    private static class TranslatingOutputStream
    extends FilteredOutputStream {
        private final OutputStream dst;
        private final Encoder<byte[], String> delegate;

        public TranslatingOutputStream(OutputStream dst, Encoder<byte[], String> delegate) {
            super(new ByteArrayOutputStream());
            this.dst = dst;
            this.delegate = delegate;
        }

        @Override
        public void close() throws IOException {
            byte[] data = ((ByteArrayOutputStream)this.out).toByteArray();
            String s = (String)this.delegate.encode((Object)data);
            this.dst.write(Strings.utf8((CharSequence)s));
            this.dst.flush();
            this.dst.close();
        }
    }
}

