/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dbinterface.postgres.queries;

import java.util.LinkedHashMap;
import org.gcube.common.dbinterface.TableAlreadyExistsException;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.CreateTableLike;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.dbinterface.postgres.queries.GetMetadataImpl;

public class CreateTableLikeImpl
implements CreateTableLike {
    private String query = "CREATE TABLE <%NAME%> ( LIKE <%TABLELIKE%> )";
    private SimpleTable tableLike;
    private String tableName;

    public SimpleTable execute(DBSession session) throws TableAlreadyExistsException, Exception {
        GetMetadataImpl metadata = new GetMetadataImpl();
        metadata.setTable(this.tableName);
        if (metadata.getResults(session).size() > 0) {
            throw new TableAlreadyExistsException("the table " + this.tableName + " already exists");
        }
        session.executeUpdate(this.getExpression());
        SimpleTable table = new SimpleTable(this.tableName);
        table.setFieldsMapping((LinkedHashMap)this.tableLike.getFieldsMapping().clone());
        return table;
    }

    public String getExpression() {
        return this.query.replace("<%NAME%>", this.tableName).replace("<%TABLELIKE%>", this.tableLike.getTableName());
    }

    public void setTableLike(SimpleTable tableLike) {
        this.tableLike = tableLike;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
}

