/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.algorithm.descriptor;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.n52.wps.algorithm.descriptor.InputDescriptor;
import org.n52.wps.io.BasicXMLTypeFactory;
import org.n52.wps.io.data.ILiteralData;
import org.n52.wps.io.data.binding.literal.LiteralAnyURIBinding;
import org.n52.wps.io.data.binding.literal.LiteralBase64BinaryBinding;
import org.n52.wps.io.data.binding.literal.LiteralBooleanBinding;
import org.n52.wps.io.data.binding.literal.LiteralByteBinding;
import org.n52.wps.io.data.binding.literal.LiteralDateTimeBinding;
import org.n52.wps.io.data.binding.literal.LiteralDoubleBinding;
import org.n52.wps.io.data.binding.literal.LiteralFloatBinding;
import org.n52.wps.io.data.binding.literal.LiteralIntBinding;
import org.n52.wps.io.data.binding.literal.LiteralLongBinding;
import org.n52.wps.io.data.binding.literal.LiteralShortBinding;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;

public class LiteralDataInputDescriptor<T extends Class<? extends ILiteralData>>
extends InputDescriptor<T> {
    private final String dataType;
    private final String defaultValue;
    private final List<String> allowedValues;

    protected LiteralDataInputDescriptor(Builder builder) {
        super(builder);
        this.dataType = builder.dataType;
        this.defaultValue = builder.defaultValue;
        this.allowedValues = builder.allowedValues != null ? Collections.unmodifiableList(builder.allowedValues) : Collections.EMPTY_LIST;
        Preconditions.checkState((!this.hasAllowedValues() || !this.hasDefaultValue() || this.allowedValues.contains(this.defaultValue) ? 1 : 0) != 0, (String)"defaultValue of %s not in set of allowedValues", (Object[])new Object[]{this.defaultValue});
    }

    public String getDataType() {
        return this.dataType;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null && this.defaultValue.length() > 0;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean hasAllowedValues() {
        return this.allowedValues != null && this.allowedValues.size() > 0;
    }

    public List<String> getAllowedValues() {
        return this.allowedValues;
    }

    public static <T extends Class<? extends ILiteralData>> Builder<?, T> builder(String identifier, T binding) {
        return new BuilderTyped<T>(identifier, binding);
    }

    public static Builder<?, Class<LiteralAnyURIBinding>> anyURIBuilder(String identifier) {
        return LiteralDataInputDescriptor.builder(identifier, LiteralAnyURIBinding.class);
    }

    public static Builder<?, Class<LiteralBase64BinaryBinding>> base64BinaryBuilder(String identifier) {
        return LiteralDataInputDescriptor.builder(identifier, LiteralBase64BinaryBinding.class);
    }

    public static Builder<?, Class<LiteralBooleanBinding>> booleanBuilder(String identifier) {
        return LiteralDataInputDescriptor.builder(identifier, LiteralBooleanBinding.class);
    }

    public static Builder<?, Class<LiteralByteBinding>> byteBuilder(String identifier) {
        return LiteralDataInputDescriptor.builder(identifier, LiteralByteBinding.class);
    }

    public static Builder<?, Class<LiteralDateTimeBinding>> dateTimeBuilder(String identifier) {
        return LiteralDataInputDescriptor.builder(identifier, LiteralDateTimeBinding.class);
    }

    public static Builder<?, Class<LiteralDoubleBinding>> doubleBuilder(String identifier) {
        return LiteralDataInputDescriptor.builder(identifier, LiteralDoubleBinding.class);
    }

    public static Builder<?, Class<LiteralFloatBinding>> floatBuilder(String identifier) {
        return LiteralDataInputDescriptor.builder(identifier, LiteralFloatBinding.class);
    }

    public static Builder<?, Class<LiteralIntBinding>> intBuilder(String identifier) {
        return LiteralDataInputDescriptor.builder(identifier, LiteralIntBinding.class);
    }

    public static Builder<?, Class<LiteralLongBinding>> longBuilder(String identifier) {
        return LiteralDataInputDescriptor.builder(identifier, LiteralLongBinding.class);
    }

    public static Builder<?, Class<LiteralShortBinding>> shortBuilder(String identifier) {
        return LiteralDataInputDescriptor.builder(identifier, LiteralShortBinding.class);
    }

    public static Builder<?, Class<LiteralStringBinding>> stringBuilder(String identifier) {
        return LiteralDataInputDescriptor.builder(identifier, LiteralStringBinding.class);
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends Class<? extends ILiteralData>>
    extends InputDescriptor.Builder<B, T> {
        private final String dataType;
        private String defaultValue;
        private List<String> allowedValues;

        protected Builder(String identifier, T binding) {
            super(identifier, binding);
            this.dataType = (String)Preconditions.checkNotNull((Object)BasicXMLTypeFactory.getXMLDataTypeforBinding(binding), (String)"Unable to resolve XML DataType for binding class %s", (Object[])new Object[]{binding});
        }

        public B defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return (B)((Builder)this.self());
        }

        public B allowedValues(Class<? extends Enum> allowedValues) {
            Enum[] constants = allowedValues.getEnumConstants();
            ArrayList<String> names = new ArrayList<String>(constants.length);
            for (Enum constant : constants) {
                names.add(constant.name());
            }
            return this.allowedValues(names);
        }

        public B allowedValues(String[] allowedValues) {
            return this.allowedValues(Arrays.asList(allowedValues));
        }

        public B allowedValues(List<String> allowedValues) {
            this.allowedValues = allowedValues;
            return (B)((Builder)this.self());
        }

        @Override
        public LiteralDataInputDescriptor<T> build() {
            return new LiteralDataInputDescriptor(this);
        }
    }

    private static class BuilderTyped<T extends Class<? extends ILiteralData>>
    extends Builder<BuilderTyped<T>, T> {
        public BuilderTyped(String identifier, T binding) {
            super(identifier, binding);
        }

        @Override
        protected BuilderTyped self() {
            return this;
        }
    }
}

