/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.harvester.postgresql.storeharvested.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import org.apache.log4j.Logger;
import org.gcube.datatransformation.harvester.core.db.HarvestedInfoObject;

public class DatabaseManagerPostgreSQL {
    private static final Logger logger = Logger.getLogger(DatabaseManagerPostgreSQL.class);
    private static DatabaseManagerPostgreSQL dbManager = null;
    public Connection connection = null;
    private String className = null;
    private String jdbcUrl = null;
    private String username = null;
    private String password = null;

    protected DatabaseManagerPostgreSQL(String className, String jdbcUrl, String username, String password) {
        this.className = className;
        this.jdbcUrl = jdbcUrl;
        this.username = username;
        this.password = password;
        this.establishConnection();
    }

    private void establishConnection() {
        try {
            Class.forName(this.className);
            this.connection = DriverManager.getConnection(this.jdbcUrl, this.username, this.password);
        }
        catch (ClassNotFoundException | SQLException e) {
            logger.error((Object)e.getMessage());
        }
    }

    public static DatabaseManagerPostgreSQL getDatabaseManagerInstance(String className, String jdbcUrl, String username, String password) {
        if (dbManager == null) {
            dbManager = new DatabaseManagerPostgreSQL(className, jdbcUrl, username, password);
        }
        return dbManager;
    }

    public void storeToDb(HarvestedInfoObject harvestedInfo) throws IOException, SQLException {
        if (this.selectFromHarvestedInfo(harvestedInfo)) {
            this.updateIntoHarvestedInfo(harvestedInfo);
        } else {
            this.insertIntoHarvestedInfo(harvestedInfo);
        }
    }

    public boolean insertIntoHarvestedInfo(HarvestedInfoObject harvestedInfo) throws IOException, SQLException {
        PreparedStatement pst = null;
        String insertQuery = "INSERT INTO harvestedinfo(har_metadataprefix, har_body, har_uri, har_verb) VALUES(?, ?, ?, ?) ";
        if (this.connection == null || this.connection.isClosed()) {
            this.establishConnection();
        }
        SQLXML xmlVal = this.connection.createSQLXML();
        pst = this.connection.prepareStatement("INSERT INTO harvestedinfo(har_metadataprefix, har_body, har_uri, har_verb) VALUES(?, ?, ?, ?) ");
        if (harvestedInfo.getMetadataPrefix() != null) {
            pst.setString(1, harvestedInfo.getMetadataPrefix());
        } else {
            pst.setNull(1, 5);
        }
        pst.setSQLXML(2, xmlVal);
        pst.setString(3, harvestedInfo.getUri());
        pst.setString(4, harvestedInfo.getVerb());
        pst.executeUpdate();
        if (pst != null) {
            pst.close();
        }
        return true;
    }

    public boolean selectFromHarvestedInfo(HarvestedInfoObject harvestedInfo) throws IOException, SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        String selectQuery = "SELECT * FROM harvestedinfo WHERE har_uri=? AND har_metadataprefix=? and har_verb=?";
        String selectQueryNULL = "SELECT * FROM harvestedinfo WHERE har_uri=? AND har_metadataprefix is NULL and har_verb=?";
        if (this.connection == null || this.connection.isClosed()) {
            this.establishConnection();
        }
        if (harvestedInfo.getMetadataPrefix() != null) {
            pst = this.connection.prepareStatement("SELECT * FROM harvestedinfo WHERE har_uri=? AND har_metadataprefix=? and har_verb=?");
            pst.setString(1, harvestedInfo.getUri());
            pst.setString(2, harvestedInfo.getMetadataPrefix());
            pst.setString(3, harvestedInfo.getVerb());
        } else {
            pst = this.connection.prepareStatement("SELECT * FROM harvestedinfo WHERE har_uri=? AND har_metadataprefix is NULL and har_verb=?");
            pst.setString(1, harvestedInfo.getUri());
            pst.setString(2, harvestedInfo.getVerb());
        }
        rs = pst.executeQuery();
        if (rs.next()) {
            if (rs != null) {
                rs.close();
            }
            if (pst != null) {
                pst.close();
            }
            return true;
        }
        if (rs != null) {
            rs.close();
        }
        if (pst != null) {
            pst.close();
        }
        return false;
    }

    public boolean updateIntoHarvestedInfo(HarvestedInfoObject harvestedInfo) throws IOException, SQLException {
        PreparedStatement pst = null;
        String updateQuery = "UPDATE harvestedinfo SET har_body = ? WHERE har_uri=? AND har_metadataprefix=? and har_verb=?";
        String updateQueryNULL = "UPDATE harvestedinfo SET har_body = ? WHERE har_uri=? AND har_metadataprefix is NULL and har_verb=?";
        if (this.connection == null || this.connection.isClosed()) {
            this.establishConnection();
        }
        SQLXML xmlVal = this.connection.createSQLXML();
        if (harvestedInfo.getMetadataPrefix() != null) {
            pst = this.connection.prepareStatement("UPDATE harvestedinfo SET har_body = ? WHERE har_uri=? AND har_metadataprefix=? and har_verb=?");
            pst.setSQLXML(1, xmlVal);
            pst.setString(2, harvestedInfo.getUri());
            pst.setString(3, harvestedInfo.getMetadataPrefix());
            pst.setString(4, harvestedInfo.getVerb());
        } else {
            pst = this.connection.prepareStatement("UPDATE harvestedinfo SET har_body = ? WHERE har_uri=? AND har_metadataprefix is NULL and har_verb=?");
            pst.setSQLXML(1, xmlVal);
            pst.setString(2, harvestedInfo.getUri());
            pst.setString(3, harvestedInfo.getVerb());
        }
        pst.executeUpdate();
        if (pst != null) {
            pst.close();
        }
        return true;
    }
}

