/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.shibboleth.util;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.theme.ThemeDisplay;
import gr.cite.shibboleth.ShibbolethSamlFilter;
import gr.cite.shibboleth.exceptions.EmailAttributeMissmatchSamlApplicationException;
import gr.cite.shibboleth.model.EduUser;
import javax.servlet.http.HttpServletRequest;

public class ShibbolethSpecificMethods {
    private static final Log log = LogFactoryUtil.getLog(ShibbolethSamlFilter.class);

    public static EduUser createUser(HttpServletRequest request) throws EmailAttributeMissmatchSamlApplicationException, SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String shibbolethEmailAttribute = PrefsPropsUtil.getString((long)themeDisplay.getCompanyId(), (String)"shibboleth.email.attribute", (String)PropsUtil.get((String)"shibboleth.email.attribute"));
        String shibbolethSurnameAttribute = PrefsPropsUtil.getString((long)themeDisplay.getCompanyId(), (String)"shibboleth.givenName.attribute", (String)PropsUtil.get((String)"shibboleth.givenName.attribute"));
        String shibbolethForeNameAttribute = PrefsPropsUtil.getString((long)themeDisplay.getCompanyId(), (String)"shibboleth.sn.attribute", (String)PropsUtil.get((String)"shibboleth.sn.attribute"));
        log.debug((Object)"Read the attributes from the Identity provider...");
        EduUser eduUser = new EduUser();
        eduUser.setEmail((String)request.getAttribute(shibbolethEmailAttribute));
        if (Validator.isNull((String)eduUser.getEmail())) {
            throw new EmailAttributeMissmatchSamlApplicationException("The data from the  identity provider does not contain the attribute >>" + shibbolethEmailAttribute + "<< change it appropriately");
        }
        eduUser.setName((String)request.getAttribute(shibbolethForeNameAttribute));
        eduUser.setSurName((String)request.getAttribute(shibbolethSurnameAttribute));
        return eduUser;
    }
}

