/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.linkedin;

import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.struts.BaseStrutsAction;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import gr.cite.additionalemailaddresses.CheckAdditionalEmailAddresses;
import gr.cite.linkedin.LinkedInOAuth;
import gr.cite.linkedin.model.UserInfo;
import gr.cite.linkedin.util.LoginHookEssentialMethods;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.gcube.portal.landingpage.LandingPageManager;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.ContainerFactory;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class LinkedInOAuth
extends BaseStrutsAction {
    private static final Log log = LogFactoryUtil.getLog(LinkedInOAuth.class);
    private static final String OAUTH2_SERVICE = "https://www.linkedin.com/uas/oauth2/authorization?response_type=code";

    public String execute(HttpServletRequest request, HttpServletResponse response) throws Exception {
        System.out.println("in LinkedInOauth execute");
        HttpSession session = request.getSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String returnFromLinkedInUrl = PortalUtil.getPortalURL((HttpServletRequest)request) + PropsUtil.get((String)"linkedIn.api.callback.url");
        String linkedInClientId = PrefsPropsUtil.getString((long)themeDisplay.getCompanyId(), (String)"linkedIn.client.id", (String)PropsUtil.get((String)"linkedIn.client.id"));
        String linkedInClientSecret = PrefsPropsUtil.getString((long)themeDisplay.getCompanyId(), (String)"linkedIn.client.secret", (String)PropsUtil.get((String)"linkedIn.client.secret"));
        Boolean canCreateAccount = PrefsPropsUtil.getBoolean((long)themeDisplay.getCompanyId(), (String)"company.security.strangers");
        User user = null;
        String landingPage = null;
        if (ParamUtil.getString((HttpServletRequest)request, (String)"cmd").equals("login")) {
            System.out.println("Initial call for login...");
            this.setTokenToSessionAndRedirectToLinkedIn(response, session, linkedInClientId, linkedInClientSecret, returnFromLinkedInUrl);
        } else if (ParamUtil.getString((HttpServletRequest)request, (String)"cmd").equals("token")) {
            System.out.println("Returning from LinkedIn... calling retrieveUsersLinkedInInfo");
            UserInfo linkedInUserInfo = this.retrieveUsersLinkedInInfo(request, session, linkedInClientId, linkedInClientSecret, returnFromLinkedInUrl);
            if (linkedInUserInfo == null) {
                log.debug((Object)"Could not extract data, returning...");
                return null;
            }
            log.debug((Object)("User's first name: " + linkedInUserInfo.getFirstName()));
            log.debug((Object)("User's last name: " + linkedInUserInfo.getLastName()));
            log.debug((Object)("User's email address: " + linkedInUserInfo.getEmailAddress()));
            try {
                user = CheckAdditionalEmailAddresses.checkInIfAdditionalEmailAndIfVerified((String)linkedInUserInfo.getEmailAddress());
            }
            catch (Exception e) {
                log.error((Object)"Error occured while searching in additional emails", (Throwable)e);
                e.printStackTrace();
                throw e;
            }
            if (user != null) {
                log.debug((Object)("Email " + linkedInUserInfo.getEmailAddress() + " has been found in additional Email Addresses"));
                session.setAttribute("userEmailAdressLinkedIn", (Object)user.getEmailAddress());
            } else if (canCreateAccount.booleanValue()) {
                long groupId = PortalUtil.getScopeGroupId((HttpServletRequest)request);
                String portalURL = PortalUtil.getPortalURL((HttpServletRequest)request, (boolean)true);
                LoginHookEssentialMethods.addUser((long)groupId, (String)portalURL, (HttpSession)session, (long)themeDisplay.getCompanyId(), (UserInfo)linkedInUserInfo);
                user = UserLocalServiceUtil.getUserById((long)UserLocalServiceUtil.getUserByEmailAddress((long)themeDisplay.getCompanyId(), (String)linkedInUserInfo.getEmailAddress()).getUserId());
            } else {
                try {
                    user = UserLocalServiceUtil.getUserByEmailAddress((long)themeDisplay.getCompanyId(), (String)linkedInUserInfo.getEmailAddress());
                    log.debug((Object)("Login user " + user.getFullName() + " email address " + user.getEmailAddress()));
                    session.setAttribute("userEmailAdressLinkedIn", (Object)user.getEmailAddress());
                }
                catch (PortalException e) {
                    SessionErrors.add((HttpSession)session, NoSuchUserException.class);
                }
            }
            if (session.getAttribute("redirectUrlAfterLogin") != null && session.getAttribute("redirectUrlAfterLogin").toString().compareTo("") != 0) {
                landingPage = session.getAttribute("redirectUrlAfterLogin").toString();
                session.setAttribute("redirectUrlAfterLogin", null);
            } else {
                landingPage = LandingPageManager.getLandingPagePath((HttpServletRequest)request, (User)user);
            }
            response.sendRedirect(landingPage);
        }
        return null;
    }

    private void setTokenToSessionAndRedirectToLinkedIn(HttpServletResponse response, HttpSession session, String linkedInClientId, String linkedInClientSecret, String returnFromLinkedInUrl) throws IOException {
        String state = this.getRandomString(8);
        session.setAttribute("linkedIn.state.session", (Object)state);
        session.setAttribute("redirect_uri", (Object)state);
        String linkedInAuthUrl = "https://www.linkedin.com/uas/oauth2/authorization?response_type=code&client_id=" + linkedInClientId + "&state=" + state + "&redirect_uri=" + returnFromLinkedInUrl + "&scope=r_liteprofile%20r_emailaddress";
        log.debug((Object)("setTokenToSessionAndRedirectToLinkedIn -> " + linkedInAuthUrl));
        response.sendRedirect(linkedInAuthUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UserInfo retrieveUsersLinkedInInfo(HttpServletRequest request, HttpSession session, String linkedInClientId, String linkedInClientSecret, String redirectURI) {
        try {
            String oauthVerifier = ParamUtil.getString((HttpServletRequest)request, (String)"code");
            log.info((Object)("retrieveUsersLinkedInInfo code=" + oauthVerifier));
            session.removeAttribute("requestTokenSecretLinkedIn");
            String controlSeq2Compare = (String)session.getAttribute("linkedIn.state.session");
            session.removeAttribute("linkedIn.state.session");
            String controlSequence = ParamUtil.getString((HttpServletRequest)request, (String)"state");
            if (ParamUtil.getString((HttpServletRequest)request, (String)"error") != null && ParamUtil.getString((HttpServletRequest)request, (String)"error").compareTo("") != 0) {
                log.warn((Object)("User refused to login with LinkedIn probably did not authorised D4Science: ParamUtil.getString(request, \"error\")=" + ParamUtil.getString((HttpServletRequest)request, (String)"error")));
                return null;
            }
            if (controlSequence.compareTo(controlSeq2Compare) != 0) {
                log.warn((Object)"The control sequence, state parameters don't match, man in the middle attack?");
                return null;
            }
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost("https://www.linkedin.com/uas/oauth2/accessToken");
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(5);
            params.add(new BasicNameValuePair("grant_type", "authorization_code"));
            params.add(new BasicNameValuePair("code", oauthVerifier));
            params.add(new BasicNameValuePair("redirect_uri", redirectURI));
            params.add(new BasicNameValuePair("client_id", linkedInClientId));
            params.add(new BasicNameValuePair("client_secret", linkedInClientSecret));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = httpResponse.getEntity();
            if (entity == null) return null;
            try (InputStream myInputStream = entity.getContent();){
                String jsonText = this.readJSONAsString(myInputStream, "UTF-8");
                log.debug((Object)("LinkedIn response: " + jsonText));
                if (jsonText == null) {
                    UserInfo userInfo = null;
                    return userInfo;
                }
                JSONParser parser = new JSONParser();
                1 containerFactory = new /* Unavailable Anonymous Inner Class!! */;
                Map json = (Map)parser.parse(jsonText, (ContainerFactory)containerFactory);
                if (json.get("error") != null) {
                    UserInfo userInfo = null;
                    return userInfo;
                }
                String token = (String)json.get("access_token");
                if (token == null) {
                    UserInfo userInfo = null;
                    return userInfo;
                }
                UserInfo userInfo = this.parseProfile((HttpClient)httpClient, token);
                return userInfo;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private UserInfo parseProfile(HttpClient httpClient, String token) {
        String emailAddress = null;
        String emailURL = "https://api.linkedin.com/v2/emailAddress?q=members&projection=(elements*(handle~))";
        try {
            URI uriEmail = new URI(emailURL);
            String jsonResponseEmail = this.doGET(uriEmail, httpClient, token);
            emailAddress = this.parseEmailJSON(jsonResponseEmail);
            URI uriProfile = new URI("https://api.linkedin.com/v2/me");
            String jsonResponseProfile = this.doGET(uriProfile, httpClient, token);
            return this.parseUserLiteProfileJSON(jsonResponseProfile, emailAddress);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String doGET(URI uri, HttpClient httpClient, String token) {
        String string;
        HttpGet request = new HttpGet(uri);
        request.addHeader("Authorization", "Bearer " + token);
        request.addHeader("cache-control", "no-cache ");
        request.addHeader("X-Restli-Protocol-Version", "2.0.0");
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)request);
        HttpEntity entity = httpResponse.getEntity();
        if (entity == null) return null;
        InputStream myInputStream = entity.getContent();
        try {
            String jsonResponse = this.readJSONAsString(myInputStream, "UTF-8");
            log.info((Object)("*****LinkedIn jsonResponse:\n" + jsonResponse));
            string = jsonResponse;
        }
        catch (Throwable throwable) {
            try {
                myInputStream.close();
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        myInputStream.close();
        return string;
    }

    private String parseEmailJSON(String jsonResponse) throws ParseException {
        JSONParser parser = new JSONParser();
        JSONObject jsonObject = (JSONObject)parser.parse(jsonResponse);
        String emailAddress = null;
        JSONArray elements = (JSONArray)jsonObject.get((Object)"elements");
        int size = elements.size();
        if (elements != null && size > 0) {
            JSONObject el0 = (JSONObject)elements.get(0);
            JSONObject handle = (JSONObject)el0.get((Object)"handle~");
            emailAddress = handle.get((Object)"emailAddress").toString();
        }
        return emailAddress;
    }

    private UserInfo parseUserLiteProfileJSON(String jsonResponse, String emailAddress) throws ParseException {
        JSONParser parser = new JSONParser();
        JSONObject jsonObject = (JSONObject)parser.parse(jsonResponse);
        String lastName = null;
        String firstName = null;
        String id = null;
        lastName = jsonObject.get((Object)"localizedLastName").toString();
        firstName = jsonObject.get((Object)"localizedFirstName").toString();
        id = jsonObject.get((Object)"id").toString();
        UserInfo toReturn = new UserInfo();
        toReturn.setEmailAddress(emailAddress);
        toReturn.setFirstName(firstName);
        toReturn.setLastName(lastName);
        toReturn.setId(id);
        return toReturn;
    }

    private String getRandomString(int length) {
        String SALTCHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
        StringBuffer salt = new StringBuffer();
        Random rnd = new Random();
        while (salt.length() < length) {
            int index = (int)(rnd.nextFloat() * (float)SALTCHARS.length());
            salt.append(SALTCHARS.charAt(index));
        }
        String saltStr = salt.toString();
        return saltStr;
    }

    public String readJSONAsString(InputStream inputStream, String encoding) throws IOException {
        return this.readFully(inputStream).toString(encoding);
    }

    public byte[] readFullyAsBytes(InputStream inputStream) throws IOException {
        return this.readFully(inputStream).toByteArray();
    }

    private ByteArrayOutputStream readFully(InputStream inputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int length = 0;
        while ((length = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        return baos;
    }
}

