/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore;

import eu.dnetlib.data.objectstore.connector.ObjectStoreDao;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.ObjectStoreFile;
import eu.dnetlib.rmi.data.ObjectStoreServiceException;
import java.io.InputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class ModularObjectStoreDeliver {
    private ObjectStoreDao dao;
    @Autowired
    private ResultSetFactory resultSetFactory;

    public ObjectStoreDao getDao() {
        return this.dao;
    }

    @Required
    public void setDao(ObjectStoreDao dao) {
        this.dao = dao;
    }

    public ResultSet<ObjectStoreFile> deliver(String objectStoreID, Long from, Long until) throws ObjectStoreServiceException {
        return this.resultSetFactory.createResultSet(this.dao.getObjectStore(objectStoreID).deliver(from, until));
    }

    public ResultSet<ObjectStoreFile> deliverIds(String objectStoreID, ResultSet<String> eprId) throws ObjectStoreServiceException {
        ResultSetClient resultSetClient = this.resultSetFactory.getResultSetClient();
        Iterable ids = resultSetClient.iter(eprId, String.class);
        return this.resultSetFactory.createResultSet(this.dao.getObjectStore(objectStoreID).deliverIds(ids));
    }

    public boolean existIDStartsWith(String obsId, String startId) throws ObjectStoreServiceException {
        return this.dao.getObjectStore(obsId).existIDStartsWith(startId);
    }

    public ObjectStoreFile deliverObject(String objectStoreID, String objectId) throws ObjectStoreServiceException {
        return this.dao.getObjectStore(objectStoreID).deliverObject(objectId);
    }

    public InputStream deliverStream(String objectStoreID, String objectId) throws ObjectStoreServiceException {
        return this.dao.getObjectStore(objectStoreID).deliverStream(objectId);
    }
}

