/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import eu.dnetlib.data.objectstore.DownloadIntoObjectStoreAction;
import eu.dnetlib.data.objectstore.DownloadPluginEnumeratorImpl;
import eu.dnetlib.data.objectstore.DownloadReport;
import eu.dnetlib.data.objectstore.DownloadReportMap;
import eu.dnetlib.data.objectstore.connector.ObjectStore;
import eu.dnetlib.data.objectstore.connector.ObjectStoreDao;
import eu.dnetlib.data.objectstore.worker.DownloadWorker;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.DownloadItem;
import eu.dnetlib.rmi.data.DownloadPlugin;
import eu.dnetlib.rmi.data.ObjectStoreServiceException;
import eu.dnetlib.rmi.data.Protocols;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DownloadServiceFeeder {
    private static final Log log = LogFactory.getLog(DownloadServiceFeeder.class);
    @Autowired
    DownloadPluginEnumeratorImpl downloadPluginEnumerator;
    @Autowired
    private ResultSetClient resultSetClient;
    @Autowired
    private ObjectStoreDao objectStoreDao;

    public static void reportException(DownloadReportMap report, DownloadItem di, Throwable e) {
        String className = e.getClass().getName();
        if (!report.containsKey(className)) {
            DownloadReport dr = new DownloadReport();
            dr.setStackTrace(Joiner.on((String)"\tat ").join((Object[])e.getStackTrace()));
            if (di != null) {
                dr.setDownloadItem(di);
            }
            report.put(className, dr);
        } else {
            ((DownloadReport)report.get(className)).incrementError();
        }
    }

    public DownloadReportMap download(String epr, String plugin, String objectStoreID, String protocol, String mimeType, int numberOfThreads, String basePath, List<String> regularExpression, int connectTimeoutMs, int readTimeoutMs, int sleepTimeMs) throws ObjectStoreServiceException {
        int i;
        DownloadPlugin downloadPlugin = this.downloadPluginEnumerator.get(plugin);
        if (basePath != null && !basePath.isEmpty()) {
            downloadPlugin.setBasePath(basePath);
        }
        Iterable urlInfo = this.resultSetClient.iter(ResultSet.fromJson((String)epr), String.class);
        ArrayBlockingQueue itemsQueue = Queues.newArrayBlockingQueue((int)(numberOfThreads * 5));
        ExecutorService executor = Executors.newFixedThreadPool(numberOfThreads);
        ObjectStore objStore = this.objectStoreDao.getObjectStore(objectStoreID);
        ArrayList responses = Lists.newArrayList();
        DownloadReportMap pluginReport = new DownloadReportMap();
        pluginReport.setStatus(true);
        if (regularExpression != null) {
            downloadPlugin.setRegularExpression(regularExpression);
        }
        Function<String, DownloadItem> applyDowunloadPlugin = input -> {
            if (input == null) {
                log.error((Object)"Input is null");
                return null;
            }
            if (input.equals("END_DOWNLOAD")) {
                return DownloadIntoObjectStoreAction.END_QUEUE;
            }
            DownloadItem di = null;
            try {
                di = DownloadItem.newObjectfromJSON((String)input);
                if (downloadPlugin.retrieveUrl(di) == null) {
                    di.setUrl(null);
                    di.setOriginalUrl(null);
                }
                return di;
            }
            catch (Throwable e) {
                DownloadServiceFeeder.reportException(pluginReport, di, e);
                log.error((Object)("Exception on transform item :" + input), e);
                return null;
            }
        };
        for (i = 0; i < numberOfThreads; ++i) {
            responses.add(executor.submit(new DownloadWorker(itemsQueue, objStore, Protocols.valueOf((String)protocol), mimeType, connectTimeoutMs, readTimeoutMs, sleepTimeMs, applyDowunloadPlugin)));
        }
        i = 0;
        if (urlInfo != null) {
            for (String downloadItem : urlInfo) {
                if (downloadItem == null) continue;
                if (i++ % 1000 == 0) {
                    log.debug((Object)("Read " + i));
                }
                try {
                    itemsQueue.put(downloadItem);
                }
                catch (Exception e) {
                    log.error((Object)("An error occurred while populating the download items queue: " + Joiner.on((String)"\tat ").join((Object[])e.getStackTrace())));
                }
            }
        }
        try {
            itemsQueue.put("END_DOWNLOAD");
        }
        catch (InterruptedException e) {
            log.error((Object)("An error occurred adding the loop terminator: " + Joiner.on((String)"\tat ").join((Object[])e.getStackTrace())));
        }
        DownloadReportMap resultMap = this.getDownloadReportMap(responses, pluginReport);
        executor.shutdown();
        return resultMap;
    }

    private DownloadReportMap getDownloadReportMap(List<Future<DownloadReportMap>> responses, DownloadReportMap pluginReport) {
        DownloadReportMap resultMap = new DownloadReportMap();
        resultMap.setStatus(true);
        for (Future<DownloadReportMap> currentResponse : responses) {
            try {
                DownloadReportMap currentMap = currentResponse.get();
                this.mergeReport(resultMap, currentMap);
                log.info((Object)("Status " + currentMap.getStatus()));
                resultMap.setStatus(resultMap.getStatus() && currentMap.getStatus());
                resultMap.setTotalDownloaded(currentMap.getTotalDownloaded() + resultMap.getTotalDownloaded());
            }
            catch (Exception e) {
                log.error((Object)e);
                resultMap.setStatus(false);
            }
        }
        this.mergeReport(resultMap, pluginReport);
        return resultMap;
    }

    private void mergeReport(DownloadReportMap resultMap, DownloadReportMap currentMap) {
        for (String key : currentMap.keySet()) {
            if (!resultMap.containsKey(key)) {
                resultMap.put(key, currentMap.get(key));
            } else {
                DownloadReport currentReport = (DownloadReport)currentMap.get(key);
                ((DownloadReport)resultMap.get(key)).incrementError(currentReport.getNumberOfOccurrences());
            }
            resultMap.setTotalDownloaded(resultMap.getTotalDownloaded() + currentMap.getTotalDownloaded());
            resultMap.setStatus(resultMap.getStatus() & currentMap.getStatus());
        }
    }
}

