/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import eu.dnetlib.data.objectstore.AbstractObjectStoreAction;
import eu.dnetlib.data.objectstore.DownloadReportMap;
import eu.dnetlib.data.objectstore.DownloadServiceFeeder;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.rmi.data.DownloadItem;
import eu.dnetlib.rmi.data.ObjectStoreServiceException;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DownloadIntoObjectStoreAction
extends AbstractObjectStoreAction {
    public static final String END_QUEUE_STRING = "END_DOWNLOAD";
    public static final DownloadItem END_QUEUE = new DownloadItem();
    private static final Log log = LogFactory.getLog(DownloadIntoObjectStoreAction.class);
    private static String DEFAULT_NUMBER_OF_THREAD = "5";
    private static int DEFAULT_TIMEOUT_MS = 5000;
    @Autowired
    private DownloadServiceFeeder downloadServiceFeeder;

    @Override
    protected void executeAsync(BlackboardServerHandler handler, BlackboardJob job) throws ObjectStoreServiceException {
        int connectTimeoutMs = DEFAULT_TIMEOUT_MS;
        int readTimeoutMs = DEFAULT_TIMEOUT_MS;
        int sleepTimeMs = 0;
        try {
            String epr = (String)job.getParameters().get("epr");
            String plugin = (String)job.getParameters().get("plugin");
            String objectStoreID = (String)job.getParameters().get("objectStoreID");
            String protocol = (String)job.getParameters().get("protocol");
            String mimeType = (String)job.getParameters().get("mimeType");
            String numberOfThreads = (String)job.getParameters().get("numberOfThreads");
            String basePath = (String)job.getParameters().get("basePath");
            String regularExpression = (String)job.getParameters().get("regularExpressions");
            String connectTimeoutMsStr = (String)job.getParameters().get("connectTimeoutMs");
            String readTimeoutMsStr = (String)job.getParameters().get("readTimeoutMs");
            String sleepTimeMsStr = (String)job.getParameters().get("sleepTimeMs");
            log.debug((Object)("regular Expression: " + regularExpression));
            List<String> expressions = null;
            if (!StringUtils.isBlank((CharSequence)regularExpression)) {
                expressions = this.parseRegexList(regularExpression);
            }
            if (StringUtils.isBlank((CharSequence)numberOfThreads)) {
                log.warn((Object)("Cannot find numberOfThread, using default value " + DEFAULT_NUMBER_OF_THREAD));
                numberOfThreads = DEFAULT_NUMBER_OF_THREAD;
            }
            if (StringUtils.isNotBlank((CharSequence)connectTimeoutMsStr)) {
                connectTimeoutMs = Integer.parseInt(connectTimeoutMsStr);
            }
            if (StringUtils.isNotBlank((CharSequence)readTimeoutMsStr)) {
                readTimeoutMs = Integer.parseInt(readTimeoutMsStr);
            }
            if (StringUtils.isNotBlank((CharSequence)sleepTimeMsStr)) {
                sleepTimeMs = Integer.parseInt(sleepTimeMsStr);
            }
            log.info((Object)String.format("downloading using plugin %s , protocol : %s into ObjectStore id %s  ", plugin, protocol, objectStoreID));
            handler.ongoing(job);
            DownloadReportMap response = this.downloadServiceFeeder.download(epr, plugin, objectStoreID, protocol, mimeType, Integer.parseInt(numberOfThreads), basePath, expressions, connectTimeoutMs, readTimeoutMs, sleepTimeMs);
            if (response.getStatus()) {
                log.info((Object)String.format("Completed Download, plugin: %s, protocol: %s, objectStoreID: %s", plugin, protocol, objectStoreID));
                job.getParameters().put("total", "" + response.getTotalDownloaded());
                job.getParameters().put("report", Base64.encodeBase64String((byte[])response.toString().getBytes()));
                handler.done(job);
            } else {
                log.error((Object)("download response is false" + response));
                handler.failed(job, (Throwable)new ObjectStoreServiceException("oops! something bad happen to our download hamsters, downloaded so far: " + response.getTotalDownloaded()));
            }
        }
        catch (Exception e) {
            log.error((Object)"An error occur while starting download", (Throwable)e);
            handler.failed(job, (Throwable)new ObjectStoreServiceException((Throwable)e));
        }
    }

    private List<String> parseRegexList(String regularExpression) {
        log.info((Object)("parsing regex list: " + regularExpression));
        return (List)new Gson().fromJson(regularExpression, new TypeToken<List<String>>(){}.getType());
    }
}

