/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular.mongodb.utils;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreDao;
import eu.dnetlib.data.mdstore.modular.mongodb.MDStoreDaoImpl;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.rmi.data.MDStoreServiceException;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.soap.EndpointReferenceBuilder;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.xml.ws.Endpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.conversions.Bson;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class MetadataCheckJob {
    private static final Log log = LogFactory.getLog(MetadataCheckJob.class);
    private UniqueServiceLocator serviceLocator;
    private Endpoint endpoint;
    private EndpointReferenceBuilder<Endpoint> eprBuilder;
    private MDStoreDao dao;
    private boolean runOnStart;

    public void runOnStart() throws MDStoreServiceException {
        if (this.isRunOnStart()) {
            log.info((Object)"running mdStore metadata check on service start");
            this.repairMetadata();
        }
    }

    public void repairMetadata() throws MDStoreServiceException {
        MongoCollection metadata = ((MDStoreDaoImpl)this.getDao()).getDb().getCollection("metadata", DBObject.class);
        if (metadata.count() != 0L) {
            log.debug((Object)"mdStore metadata doesn't need to be repaired");
            return;
        }
        try {
            List mdStores = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile("//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='MDStoreDSResourceType' and .//RESOURCE_URI/@value='" + this.getServiceAddress() + "']");
            log.debug((Object)"repairing mdstore metadata");
            if (mdStores != null) {
                for (String MDStoreProfile : mdStores) {
                    DBObject mdInfo = this.getMdInfo(MDStoreProfile);
                    metadata.findOneAndReplace((Bson)new BasicDBObject("mdId", mdInfo.get("mdId")), (Object)mdInfo);
                }
            }
            log.debug((Object)"FINISHED repairing mdstore metadata");
        }
        catch (ISLookUpException e) {
            throw new RuntimeException(e);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
    }

    private DBObject getMdInfo(String MDStoreProfile) throws DocumentException {
        Document doc = new SAXReader().read((Reader)new StringReader(MDStoreProfile));
        BasicDBObject dbo = new BasicDBObject();
        dbo.put("mdId", (Object)doc.valueOf("//RESOURCE_IDENTIFIER/@value"));
        dbo.put("format", (Object)doc.valueOf("//METADATA_FORMAT/text()"));
        dbo.put("layout", (Object)doc.valueOf("//METADATA_FORMAT_LAYOUT/text()"));
        dbo.put("interpretation", (Object)doc.valueOf("//METADATA_FORMAT_INTERPRETATION/text()"));
        dbo.put("size", (Object)doc.valueOf("//NUMBER_OF_RECORDS/text()"));
        return dbo;
    }

    private String getServiceAddress() {
        return this.getEprBuilder().getAddress((Object)this.getEndpoint()) + "?wsdl";
    }

    public EndpointReferenceBuilder<Endpoint> getEprBuilder() {
        return this.eprBuilder;
    }

    @Required
    public void setEprBuilder(EndpointReferenceBuilder<Endpoint> eprBuilder) {
        this.eprBuilder = eprBuilder;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Required
    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public MDStoreDao getDao() {
        return this.dao;
    }

    @Required
    public void setDao(MDStoreDao dao) {
        this.dao = dao;
    }

    public boolean isRunOnStart() {
        return this.runOnStart;
    }

    @Required
    public void setRunOnStart(boolean runOnStart) {
        this.runOnStart = runOnStart;
    }

    public UniqueServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    @Required
    public void setServiceLocator(UniqueServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }
}

