/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import eu.dnetlib.miscutils.collections.Pair;
import eu.dnetlib.miscutils.factory.Factory;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BulkRecordMapperFactory
implements Factory<Function<String, Pair<String, String>>> {
    protected static final String MD_RECORD = "mdRecord";
    protected static final String MD_ID = "mdId";
    protected static final String RECORD = "record";
    private static final Log log = LogFactory.getLog(BulkRecordMapperFactory.class);
    protected ThreadLocal<XMLInputFactory> inputFactory = new ThreadLocal<XMLInputFactory>(){

        @Override
        protected XMLInputFactory initialValue() {
            return XMLInputFactory.newInstance();
        }
    };
    protected ThreadLocal<XMLOutputFactory> outputFactory = new ThreadLocal<XMLOutputFactory>(){

        @Override
        protected XMLOutputFactory initialValue() {
            return XMLOutputFactory.newInstance();
        }
    };
    protected ThreadLocal<XMLEventFactory> eventFactory = new ThreadLocal<XMLEventFactory>(){

        @Override
        protected XMLEventFactory initialValue() {
            return XMLEventFactory.newInstance();
        }
    };

    public Function<String, Pair<String, String>> newInstance() {
        return new Function<String, Pair<String, String>>(){
            private String mdId = null;
            private String record = null;

            public Pair<String, String> apply(String embeddedRecord) {
                try {
                    XMLEventReader parser = BulkRecordMapperFactory.this.inputFactory.get().createXMLEventReader(new StringReader(embeddedRecord));
                    while (parser.hasNext()) {
                        XMLEvent event = parser.nextEvent();
                        if (event == null || !event.isStartElement()) continue;
                        String localName = event.asStartElement().getName().getLocalPart();
                        if (BulkRecordMapperFactory.MD_RECORD.equals(localName)) {
                            this.mdId = event.asStartElement().getAttributeByName(new QName(BulkRecordMapperFactory.MD_ID)).getValue();
                            continue;
                        }
                        if (!BulkRecordMapperFactory.RECORD.equals(localName)) continue;
                        this.record = BulkRecordMapperFactory.this.getRecord(embeddedRecord, parser);
                    }
                }
                catch (XMLStreamException e) {
                    log.error((Object)("error parsing record: " + embeddedRecord));
                }
                return new Pair((Object)this.mdId, (Object)this.record);
            }
        };
    }

    protected String getRecord(String record, XMLEventReader parser) throws XMLStreamException {
        StringWriter results = new StringWriter();
        XMLEventWriter writer = this.outputFactory.get().createXMLEventWriter(results);
        ArrayList namespaces = Lists.newArrayList((Object[])new Namespace[]{this.eventFactory.get().createNamespace("dri", "http://www.driver-repository.eu/namespace/dri"), this.eventFactory.get().createNamespace("dr", "http://www.driver-repository.eu/namespace/dr"), this.eventFactory.get().createNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance"), this.eventFactory.get().createNamespace("dc", "http://purl.org/dc/elements/1.1/")});
        StartElement newRecord = this.eventFactory.get().createStartElement("", null, RECORD, null, namespaces.iterator());
        writer.add(newRecord);
        while (parser.hasNext()) {
            XMLEvent resultEvent = parser.nextEvent();
            if (resultEvent.isEndElement() && resultEvent.asEndElement().getName().getLocalPart().equals(RECORD)) {
                writer.add(resultEvent);
                break;
            }
            writer.add(resultEvent);
        }
        writer.close();
        return results.toString();
    }
}

