/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.sftp;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import eu.dnetlib.data.collector.plugins.sftp.SftpIteratorFactory;
import eu.dnetlib.rmi.data.CollectorServiceException;
import eu.dnetlib.rmi.data.InterfaceDescriptor;
import eu.dnetlib.rmi.data.plugin.AbstractCollectorPlugin;
import java.util.Set;

public abstract class AbstractSftpCollectorPlugin
extends AbstractCollectorPlugin {
    private SftpIteratorFactory sftpIteratorFactory;

    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor, String fromDate, String toDate) throws CollectorServiceException {
        String baseUrl = interfaceDescriptor.getBaseUrl();
        String recursive = (String)interfaceDescriptor.getParams().get("recursive");
        String extensions = (String)interfaceDescriptor.getParams().get("extensions");
        if (baseUrl == null || baseUrl.isEmpty()) {
            throw new CollectorServiceException("Param 'baseurl' is null or empty");
        }
        if (recursive == null || recursive.isEmpty()) {
            throw new CollectorServiceException("Param 'recursive' is null or empty");
        }
        if (extensions == null || extensions.isEmpty()) {
            throw new CollectorServiceException("Param 'extensions' is null or empty");
        }
        if (fromDate != null && !fromDate.matches("\\d{4}-\\d{2}-\\d{2}(T\\d{2}:\\d{2}:\\d{2}Z)?+") && !fromDate.matches("\\d{4}-\\d{2}-\\d{2}")) {
            throw new CollectorServiceException("Invalid date (yyyy-MM-dd'T'HH:mm:ss'Z' or yyyy-MM-dd ): " + fromDate);
        }
        Set<String> extensionSet = this.parseSet(extensions);
        return this.getIterable(interfaceDescriptor, baseUrl, Boolean.parseBoolean(recursive), extensionSet, fromDate);
    }

    protected abstract Iterable<String> getIterable(InterfaceDescriptor var1, String var2, boolean var3, Set<String> var4, String var5) throws CollectorServiceException;

    private Set<String> parseSet(String extensions) {
        return Sets.newHashSet((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)extensions));
    }

    public SftpIteratorFactory getSftpIteratorFactory() {
        return this.sftpIteratorFactory;
    }

    public void setSftpIteratorFactory(SftpIteratorFactory sftpIteratorFactory) {
        this.sftpIteratorFactory = sftpIteratorFactory;
    }
}

