/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.mongo;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.dnetlib.data.collector.ThreadSafeIterator;
import java.io.BufferedReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MongoDumpIterator
extends ThreadSafeIterator {
    private static final Log log = LogFactory.getLog(MongoDumpIterator.class);
    private final BufferedReader inputStream;
    private String currentLine = null;

    public MongoDumpIterator(BufferedReader inputStream) {
        this.inputStream = inputStream;
        this.currentLine = this.getNextLine();
    }

    @Override
    public boolean doHasNext() {
        return this.currentLine != null;
    }

    @Override
    public String doNext() {
        String returnedString = this.currentLine;
        this.currentLine = this.getNextLine();
        return returnedString;
    }

    private String getNextLine() {
        String input = null;
        try {
            input = this.inputStream.readLine();
            while (input != null) {
                try {
                    JsonElement jElement = new JsonParser().parse(input);
                    JsonObject jobject = jElement.getAsJsonObject();
                    if (jobject.has("body")) {
                        return jobject.get("body").getAsString();
                    }
                }
                catch (Throwable jElement) {
                    // empty catch block
                }
                input = this.inputStream.readLine();
            }
            return null;
        }
        catch (Exception e) {
            log.error((Object)("Error on parsing json " + input));
            log.error((Object)e.getMessage());
            e.printStackTrace();
            return null;
        }
    }
}

