/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collective.transformation.rulelanguage.util;

import eu.dnetlib.data.collective.transformation.rulelanguage.Argument;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringEscapeUtils;

public class FunctionCall {
    private String externalFunctionName;
    private Map<String, String> paramMap;
    private List<String> paramList;
    private String uuid;
    private List<Argument> argList = new LinkedList<Argument>();
    private boolean isStatic = false;
    private boolean doPreprocess = true;

    public FunctionCall(boolean aIsStatic) {
        this.uuid = UUID.randomUUID().toString();
        this.isStatic = aIsStatic;
    }

    public FunctionCall(boolean aIsStatic, boolean aDoPreprocess) {
        this(aIsStatic);
        this.doPreprocess = aDoPreprocess;
    }

    public boolean doPreprocess() {
        return this.doPreprocess;
    }

    public String getXSLpreparatedFunctionCall() {
        return "TransformationFunction:" + this.externalFunctionName + "($tf, '" + this.uuid + "', $index)";
    }

    public String getXSLpositionFunctionCall() {
        return "TransformationFunction:" + this.externalFunctionName + "($tf, '" + this.uuid + "', $index, $posVar)";
    }

    public String getXSLdirectFunctionCall(String aCallId) {
        if (this.externalFunctionName.equals("regExpr")) {
            return "TransformationFunction:" + this.externalFunctionName + "($tf, " + this.paramMap.get("expr1") + ", " + this.paramMap.get("expr2") + ", '" + this.paramMap.get("regularExpression") + "')";
        }
        if (this.externalFunctionName.equals("convert")) {
            if (this.paramMap.containsKey("defaultPattern") && this.paramMap.containsKey("function")) {
                return "TransformationFunction:" + this.externalFunctionName + "($tf, " + this.paramMap.get("fieldValue") + ", '" + this.paramMap.get("vocabularyName") + "', '" + this.paramMap.get("defaultPattern") + "', '" + this.paramMap.get("function") + "')";
            }
            return "TransformationFunction:" + this.externalFunctionName + "($tf, " + this.paramMap.get("fieldValue") + ", '" + this.paramMap.get("vocabularyName") + "')";
        }
        if (this.externalFunctionName.equals("convertString")) {
            if (this.paramMap.containsKey("defaultPattern") && this.paramMap.containsKey("function")) {
                return "TransformationFunction:" + this.externalFunctionName + "($tf, " + this.paramMap.get("fieldValue") + ", '" + this.paramMap.get("vocabularyName") + "', '" + this.paramMap.get("defaultPattern") + "', '" + this.paramMap.get("function") + "')";
            }
            return "TransformationFunction:" + this.externalFunctionName + "($tf, " + this.paramMap.get("fieldValue") + ", '" + this.paramMap.get("vocabularyName") + "')";
        }
        if (this.externalFunctionName.equals("split")) {
            return "TransformationFunction:" + this.externalFunctionName + "($tf, " + this.paramMap.get("inputExpr") + ", '" + this.paramMap.get("regExpr") + "', '" + aCallId + "')";
        }
        if (this.externalFunctionName.equals("lookup")) {
            return "TransformationFunction:" + this.externalFunctionName + "($tf, " + this.paramMap.get("exprIdentifier") + ", '" + this.paramMap.get("exprProperty") + "')";
        }
        if (this.externalFunctionName.equals("identifierExtract")) {
            return "TransformationFunction:" + this.externalFunctionName + "($tf, '" + StringEscapeUtils.escapeXml10((String)this.paramMap.get("xpathExprJson")) + "', " + this.paramMap.get("xpathExprInputSource") + ", '" + StringEscapeUtils.escapeXml10((String)this.paramMap.get("regExpr")) + "')";
        }
        throw new IllegalStateException("unsupported function call: " + this.externalFunctionName);
    }

    public String getXSLdirectFunctionCallById(String aCallId) {
        if (this.externalFunctionName.equals("split")) {
            return "TransformationFunction:" + this.externalFunctionName + "($tf, '" + aCallId + "')";
        }
        throw new IllegalStateException("unsupported function call: " + this.externalFunctionName);
    }

    public String getExternalFunctionName() {
        return this.externalFunctionName;
    }

    public void setExternalFunctionName(String externalFunctionName) {
        this.externalFunctionName = externalFunctionName;
    }

    public void addArgument(Argument arg) {
        this.argList.add(arg);
    }

    public List<Argument> getArguments() {
        return this.argList;
    }

    public void setArguments(List<Argument> aArgList) {
        this.argList = aArgList;
    }

    public Map<String, String> getParameters() {
        return this.paramMap;
    }

    public void setParameters(Map<String, String> parameters) {
        this.paramMap = parameters;
    }

    public String getUuid() {
        return this.uuid;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public List<String> getParamList() {
        return this.paramList;
    }

    public void setParamList(List<String> paramList) {
        this.paramList = paramList;
    }
}

