/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.common.utils;

import eu.dnetlib.common.utils.XMLException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;

public class XMLUtils {
    private static final SAXReader reader = new SAXReader();
    private static Map<String, String> nsMap = new HashMap<String, String>();

    public static Document getDocument(String document) throws XMLException {
        try {
            return reader.read((Reader)new StringReader(document));
        }
        catch (DocumentException e) {
            throw new XMLException((Exception)((Object)e));
        }
    }

    public static void setNamespaces(Map<String, String> nsMap) {
        XMLUtils.nsMap = nsMap;
    }

    public static String evaluate(String document, String expression) throws XMLException {
        XPath xpath = DocumentHelper.createXPath((String)expression);
        xpath.setNamespaceURIs(nsMap);
        return xpath.valueOf((Object)XMLUtils.getDocument(document));
    }

    public static String evaluate(Node document, String expression) throws XMLException {
        XPath xpath = DocumentHelper.createXPath((String)expression);
        xpath.setNamespaceURIs(nsMap);
        return xpath.valueOf((Object)document);
    }

    public static List<Node> getNodes(Node document, String expression) throws XMLException {
        XPath xpath = DocumentHelper.createXPath((String)expression);
        xpath.setNamespaceURIs(nsMap);
        return xpath.selectNodes((Object)document, xpath);
    }

    public static Node getNode(Node document, String expression) {
        return document.selectSingleNode(expression);
    }
}

