package eu.dnetlib.data.collector.plugins.sftp;

import java.util.Set;

import eu.dnetlib.rmi.data.CollectorServiceException;
import eu.dnetlib.rmi.data.InterfaceDescriptor;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;

/**
 * Created by alessia on 15/03/17.
 */
public class SftpPubKeyCollectorPlugin extends AbstractSftpCollectorPlugin {

	private static final Log log = LogFactory.getLog(SftpPubKeyCollectorPlugin.class);
	@Value("${collector.sftp.auth.prvKeyPath}")
	private String prvKeyFilePath;
	@Value("${collector.sftp.auth.passphrase}")
	private String passphrase;
	@Value("${collector.sftp.auth.knownHostsPath}")
	private String knownHostsFile;

	@Override
	protected Iterable<String> getIterable(final InterfaceDescriptor interfaceDescriptor,
			final String baseUrl,
			final boolean isRecursive,
			final Set<String> extensionSet,
			final String fromDate) throws CollectorServiceException {

		String username = interfaceDescriptor.getParams().get("username");
		if(StringUtils.isBlank(username)) {
			log.warn("Param 'username' is null or empty");
		}
		return () -> getSftpIteratorFactory().newIteratorPubKeyAuth(baseUrl, username, prvKeyFilePath, passphrase, knownHostsFile, isRecursive, extensionSet, fromDate);
	}

}
