package eu.dnetlib.data.collector.plugins;

import com.google.common.collect.Lists;
import eu.dnetlib.data.collector.plugins.oai.engine.HttpConnector;
import eu.dnetlib.rmi.data.CollectorServiceException;
import eu.dnetlib.rmi.data.InterfaceDescriptor;
import eu.dnetlib.rmi.data.plugin.AbstractCollectorPlugin;
import org.springframework.beans.factory.annotation.Required;

/**
 * Collects whatever is in the given baseUrl. If you have multiple records to be splitted, then use eu.dnetlib.data.collector.plugins.HttpCollectorPlugin.
 * If you have a CSV file, then prefer eu.dnetlib.data.collector.plugins.HttpCSVCollectorPlugin .
 */
public class HttpSimpleCollectorPlugin extends AbstractCollectorPlugin {

	private HttpConnector httpConnector;

	@Override
	public Iterable<String> collect(final InterfaceDescriptor interfaceDescriptor, final String fromDate, final String untilDate)
			throws CollectorServiceException {

		String url = interfaceDescriptor.getBaseUrl();
		return Lists.newArrayList(httpConnector.getInputSource(url));
	}

	public HttpConnector getHttpConnector() {
		return httpConnector;
	}

	@Required
	public void setHttpConnector(HttpConnector httpConnector) {
		this.httpConnector = httpConnector;
	}
}
