/*
 * Decompiled with CFR 0.152.
 */
package eu.openaire.publications_retriever.util.http;

import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.http.HttpClient;
import java.time.Duration;

public class HttpClientUtils {
    private static final HttpClient client;
    public static final CookieManager cookieManager;
    private static final Duration maxConnectWaitingTime;

    public static HttpClient getHttpClient() {
        return client;
    }

    static {
        cookieManager = new CookieManager();
        maxConnectWaitingTime = Duration.ofSeconds(5L);
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ORIGINAL_SERVER);
        CookieHandler.setDefault(cookieManager);
        client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NEVER).connectTimeout(maxConnectWaitingTime).cookieHandler(CookieHandler.getDefault()).build();
    }
}

